package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RouteIngressFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRouteIngressFluentAssert<S extends AbstractRouteIngressFluentAssert<S, A>, A extends RouteIngressFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRouteIngressFluentAssert}</code> to make assertions on actual RouteIngressFluent.
   * @param actual the RouteIngressFluent we want to make assertions on.
   */
  protected AbstractRouteIngressFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RouteIngressFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RouteIngressFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RouteIngressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressFluent's conditions contains the given RouteIngressCondition elements.
   * @param conditions the given elements that should be contained in actual RouteIngressFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual RouteIngressFluent's conditions does not contain all given RouteIngressCondition elements.
   */
  public S hasConditions(RouteIngressCondition... conditions) {
    // check that actual RouteIngressFluent we want to make assertions on is not null.
    isNotNull();

    // check that given RouteIngressCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressFluent's conditions contains <b>only<b> the given RouteIngressCondition elements and nothing else in whatever order.
   * @param conditions the given elements that should be contained in actual RouteIngressFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual RouteIngressFluent's conditions does not contain all given RouteIngressCondition elements.
   */
  public S hasOnlyConditions(RouteIngressCondition... conditions) {
    // check that actual RouteIngressFluent we want to make assertions on is not null.
    isNotNull();

    // check that given RouteIngressCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressFluent's conditions does not contain the given RouteIngressCondition elements.
   *
   * @param conditions the given elements that should not be in actual RouteIngressFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual RouteIngressFluent's conditions contains any given RouteIngressCondition elements.
   */
  public S doesNotHaveConditions(RouteIngressCondition... conditions) {
    // check that actual RouteIngressFluent we want to make assertions on is not null.
    isNotNull();

    // check that given RouteIngressCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressFluent has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual RouteIngressFluent's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual RouteIngressFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual RouteIngressFluent's host is equal to the given one.
   * @param host the given host to compare the actual RouteIngressFluent's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressFluent's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual RouteIngressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressFluent's routerName is equal to the given one.
   * @param routerName the given routerName to compare the actual RouteIngressFluent's routerName to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressFluent's routerName is not equal to the given one.
   */
  public S hasRouterName(String routerName) {
    // check that actual RouteIngressFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting routerName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRouterName = actual.getRouterName();
    if (!Objects.areEqual(actualRouterName, routerName)) {
      failWithMessage(assertjErrorMessage, actual, routerName, actualRouterName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
