package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RouteIngressCondition} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRouteIngressConditionAssert<S extends AbstractRouteIngressConditionAssert<S, A>, A extends RouteIngressCondition> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRouteIngressConditionAssert}</code> to make assertions on actual RouteIngressCondition.
   * @param actual the RouteIngressCondition we want to make assertions on.
   */
  protected AbstractRouteIngressConditionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RouteIngressCondition's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RouteIngressCondition's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressCondition's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RouteIngressCondition we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressCondition's lastTransitionTime is equal to the given one.
   * @param lastTransitionTime the given lastTransitionTime to compare the actual RouteIngressCondition's lastTransitionTime to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressCondition's lastTransitionTime is not equal to the given one.
   */
  public S hasLastTransitionTime(String lastTransitionTime) {
    // check that actual RouteIngressCondition we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastTransitionTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastTransitionTime = actual.getLastTransitionTime();
    if (!Objects.areEqual(actualLastTransitionTime, lastTransitionTime)) {
      failWithMessage(assertjErrorMessage, actual, lastTransitionTime, actualLastTransitionTime);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressCondition's message is equal to the given one.
   * @param message the given message to compare the actual RouteIngressCondition's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressCondition's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual RouteIngressCondition we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressCondition's reason is equal to the given one.
   * @param reason the given reason to compare the actual RouteIngressCondition's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressCondition's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual RouteIngressCondition we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressCondition's status is equal to the given one.
   * @param status the given status to compare the actual RouteIngressCondition's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressCondition's status is not equal to the given one.
   */
  public S hasStatus(String status) {
    // check that actual RouteIngressCondition we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RouteIngressCondition's type is equal to the given one.
   * @param type the given type to compare the actual RouteIngressCondition's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RouteIngressCondition's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual RouteIngressCondition we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
