package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LifecycleHookFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLifecycleHookFluentImplAssert<S extends AbstractLifecycleHookFluentImplAssert<S, A>, A extends LifecycleHookFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLifecycleHookFluentImplAssert}</code> to make assertions on actual LifecycleHookFluentImpl.
   * @param actual the LifecycleHookFluentImpl we want to make assertions on.
   */
  protected AbstractLifecycleHookFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LifecycleHookFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LifecycleHookFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleHookFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LifecycleHookFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleHookFluentImpl's execNewPod is equal to the given one.
   * @param execNewPod the given execNewPod to compare the actual LifecycleHookFluentImpl's execNewPod to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleHookFluentImpl's execNewPod is not equal to the given one.
   */
  public S hasExecNewPod(ExecNewPodHook execNewPod) {
    // check that actual LifecycleHookFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting execNewPod of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ExecNewPodHook actualExecNewPod = actual.getExecNewPod();
    if (!Objects.areEqual(actualExecNewPod, execNewPod)) {
      failWithMessage(assertjErrorMessage, actual, execNewPod, actualExecNewPod);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleHookFluentImpl's failurePolicy is equal to the given one.
   * @param failurePolicy the given failurePolicy to compare the actual LifecycleHookFluentImpl's failurePolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleHookFluentImpl's failurePolicy is not equal to the given one.
   */
  public S hasFailurePolicy(String failurePolicy) {
    // check that actual LifecycleHookFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting failurePolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFailurePolicy = actual.getFailurePolicy();
    if (!Objects.areEqual(actualFailurePolicy, failurePolicy)) {
      failWithMessage(assertjErrorMessage, actual, failurePolicy, actualFailurePolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleHookFluentImpl's tagImages contains the given TagImageHook elements.
   * @param tagImages the given elements that should be contained in actual LifecycleHookFluentImpl's tagImages.
   * @return this assertion object.
   * @throws AssertionError if the actual LifecycleHookFluentImpl's tagImages does not contain all given TagImageHook elements.
   */
  public S hasTagImages(TagImageHook... tagImages) {
    // check that actual LifecycleHookFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given TagImageHook varargs is not null.
    if (tagImages == null) failWithMessage("Expecting tagImages parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTagImages(), tagImages);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleHookFluentImpl's tagImages contains <b>only<b> the given TagImageHook elements and nothing else in whatever order.
   * @param tagImages the given elements that should be contained in actual LifecycleHookFluentImpl's tagImages.
   * @return this assertion object.
   * @throws AssertionError if the actual LifecycleHookFluentImpl's tagImages does not contain all given TagImageHook elements.
   */
  public S hasOnlyTagImages(TagImageHook... tagImages) {
    // check that actual LifecycleHookFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given TagImageHook varargs is not null.
    if (tagImages == null) failWithMessage("Expecting tagImages parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getTagImages(), tagImages);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleHookFluentImpl's tagImages does not contain the given TagImageHook elements.
   *
   * @param tagImages the given elements that should not be in actual LifecycleHookFluentImpl's tagImages.
   * @return this assertion object.
   * @throws AssertionError if the actual LifecycleHookFluentImpl's tagImages contains any given TagImageHook elements.
   */
  public S doesNotHaveTagImages(TagImageHook... tagImages) {
    // check that actual LifecycleHookFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given TagImageHook varargs is not null.
    if (tagImages == null) failWithMessage("Expecting tagImages parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getTagImages(), tagImages);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleHookFluentImpl has no tagImages.
   * @return this assertion object.
   * @throws AssertionError if the actual LifecycleHookFluentImpl's tagImages is not empty.
   */
  public S hasNoTagImages() {
    // check that actual LifecycleHookFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have tagImages but had :\n  <%s>";
    
    // check
    if (actual.getTagImages().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTagImages());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
