package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ImageSourcePathFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageSourcePathFluentAssert<S extends AbstractImageSourcePathFluentAssert<S, A>, A extends ImageSourcePathFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageSourcePathFluentAssert}</code> to make assertions on actual ImageSourcePathFluent.
   * @param actual the ImageSourcePathFluent we want to make assertions on.
   */
  protected AbstractImageSourcePathFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ImageSourcePathFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ImageSourcePathFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageSourcePathFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ImageSourcePathFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageSourcePathFluent's destinationDir is equal to the given one.
   * @param destinationDir the given destinationDir to compare the actual ImageSourcePathFluent's destinationDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageSourcePathFluent's destinationDir is not equal to the given one.
   */
  public S hasDestinationDir(String destinationDir) {
    // check that actual ImageSourcePathFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting destinationDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDestinationDir = actual.getDestinationDir();
    if (!Objects.areEqual(actualDestinationDir, destinationDir)) {
      failWithMessage(assertjErrorMessage, actual, destinationDir, actualDestinationDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageSourcePathFluent's sourcePath is equal to the given one.
   * @param sourcePath the given sourcePath to compare the actual ImageSourcePathFluent's sourcePath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageSourcePathFluent's sourcePath is not equal to the given one.
   */
  public S hasSourcePath(String sourcePath) {
    // check that actual ImageSourcePathFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting sourcePath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSourcePath = actual.getSourcePath();
    if (!Objects.areEqual(actualSourcePath, sourcePath)) {
      failWithMessage(assertjErrorMessage, actual, sourcePath, actualSourcePath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
