package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CustomBuildStrategyFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomBuildStrategyFluentAssert<S extends AbstractCustomBuildStrategyFluentAssert<S, A>, A extends CustomBuildStrategyFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomBuildStrategyFluentAssert}</code> to make assertions on actual CustomBuildStrategyFluent.
   * @param actual the CustomBuildStrategyFluent we want to make assertions on.
   */
  protected AbstractCustomBuildStrategyFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CustomBuildStrategyFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategyFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's buildAPIVersion is equal to the given one.
   * @param buildAPIVersion the given buildAPIVersion to compare the actual CustomBuildStrategyFluent's buildAPIVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategyFluent's buildAPIVersion is not equal to the given one.
   */
  public S hasBuildAPIVersion(String buildAPIVersion) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting buildAPIVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualBuildAPIVersion = actual.getBuildAPIVersion();
    if (!Objects.areEqual(actualBuildAPIVersion, buildAPIVersion)) {
      failWithMessage(assertjErrorMessage, actual, buildAPIVersion, actualBuildAPIVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's env contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param env the given elements that should be contained in actual CustomBuildStrategyFluent's env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluent's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's env contains <b>only<b> the given io.fabric8.kubernetes.api.model.EnvVar elements and nothing else in whatever order.
   * @param env the given elements that should be contained in actual CustomBuildStrategyFluent's env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluent's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasOnlyEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's env does not contain the given io.fabric8.kubernetes.api.model.EnvVar elements.
   *
   * @param env the given elements that should not be in actual CustomBuildStrategyFluent's env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluent's env contains any given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S doesNotHaveEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluent's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CustomBuildStrategyFluent's from is equal to the given one.
   * @param from the given from to compare the actual CustomBuildStrategyFluent's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategyFluent's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's pullSecret is equal to the given one.
   * @param pullSecret the given pullSecret to compare the actual CustomBuildStrategyFluent's pullSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategyFluent's pullSecret is not equal to the given one.
   */
  public S hasPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting pullSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualPullSecret = actual.getPullSecret();
    if (!Objects.areEqual(actualPullSecret, pullSecret)) {
      failWithMessage(assertjErrorMessage, actual, pullSecret, actualPullSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's secrets contains the given SecretSpec elements.
   * @param secrets the given elements that should be contained in actual CustomBuildStrategyFluent's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluent's secrets does not contain all given SecretSpec elements.
   */
  public S hasSecrets(SecretSpec... secrets) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // check that given SecretSpec varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's secrets contains <b>only<b> the given SecretSpec elements and nothing else in whatever order.
   * @param secrets the given elements that should be contained in actual CustomBuildStrategyFluent's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluent's secrets does not contain all given SecretSpec elements.
   */
  public S hasOnlySecrets(SecretSpec... secrets) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // check that given SecretSpec varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent's secrets does not contain the given SecretSpec elements.
   *
   * @param secrets the given elements that should not be in actual CustomBuildStrategyFluent's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluent's secrets contains any given SecretSpec elements.
   */
  public S doesNotHaveSecrets(SecretSpec... secrets) {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // check that given SecretSpec varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluent has no secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluent's secrets is not empty.
   */
  public S hasNoSecrets() {
    // check that actual CustomBuildStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have secrets but had :\n  <%s>";
    
    // check
    if (actual.getSecrets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSecrets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
