package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildSourceFluentAssert<S extends AbstractBuildSourceFluentAssert<S, A>, A extends BuildSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildSourceFluentAssert}</code> to make assertions on actual BuildSourceFluent.
   * @param actual the BuildSourceFluent we want to make assertions on.
   */
  protected AbstractBuildSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's binary is equal to the given one.
   * @param binary the given binary to compare the actual BuildSourceFluent's binary to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluent's binary is not equal to the given one.
   */
  public S hasBinary(BinaryBuildSource binary) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting binary of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BinaryBuildSource actualBinary = actual.getBinary();
    if (!Objects.areEqual(actualBinary, binary)) {
      failWithMessage(assertjErrorMessage, actual, binary, actualBinary);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's contextDir is equal to the given one.
   * @param contextDir the given contextDir to compare the actual BuildSourceFluent's contextDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluent's contextDir is not equal to the given one.
   */
  public S hasContextDir(String contextDir) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting contextDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContextDir = actual.getContextDir();
    if (!Objects.areEqual(actualContextDir, contextDir)) {
      failWithMessage(assertjErrorMessage, actual, contextDir, actualContextDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's dockerfile is equal to the given one.
   * @param dockerfile the given dockerfile to compare the actual BuildSourceFluent's dockerfile to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluent's dockerfile is not equal to the given one.
   */
  public S hasDockerfile(String dockerfile) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerfile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerfile = actual.getDockerfile();
    if (!Objects.areEqual(actualDockerfile, dockerfile)) {
      failWithMessage(assertjErrorMessage, actual, dockerfile, actualDockerfile);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's git is equal to the given one.
   * @param git the given git to compare the actual BuildSourceFluent's git to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluent's git is not equal to the given one.
   */
  public S hasGit(GitBuildSource git) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting git of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitBuildSource actualGit = actual.getGit();
    if (!Objects.areEqual(actualGit, git)) {
      failWithMessage(assertjErrorMessage, actual, git, actualGit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's images contains the given ImageSource elements.
   * @param images the given elements that should be contained in actual BuildSourceFluent's images.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildSourceFluent's images does not contain all given ImageSource elements.
   */
  public S hasImages(ImageSource... images) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ImageSource varargs is not null.
    if (images == null) failWithMessage("Expecting images parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getImages(), images);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's images contains <b>only<b> the given ImageSource elements and nothing else in whatever order.
   * @param images the given elements that should be contained in actual BuildSourceFluent's images.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildSourceFluent's images does not contain all given ImageSource elements.
   */
  public S hasOnlyImages(ImageSource... images) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ImageSource varargs is not null.
    if (images == null) failWithMessage("Expecting images parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getImages(), images);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's images does not contain the given ImageSource elements.
   *
   * @param images the given elements that should not be in actual BuildSourceFluent's images.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildSourceFluent's images contains any given ImageSource elements.
   */
  public S doesNotHaveImages(ImageSource... images) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ImageSource varargs is not null.
    if (images == null) failWithMessage("Expecting images parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getImages(), images);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent has no images.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildSourceFluent's images is not empty.
   */
  public S hasNoImages() {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have images but had :\n  <%s>";
    
    // check
    if (actual.getImages().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getImages());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual BuildSourceFluent's secrets contains the given SecretBuildSource elements.
   * @param secrets the given elements that should be contained in actual BuildSourceFluent's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildSourceFluent's secrets does not contain all given SecretBuildSource elements.
   */
  public S hasSecrets(SecretBuildSource... secrets) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given SecretBuildSource varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's secrets contains <b>only<b> the given SecretBuildSource elements and nothing else in whatever order.
   * @param secrets the given elements that should be contained in actual BuildSourceFluent's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildSourceFluent's secrets does not contain all given SecretBuildSource elements.
   */
  public S hasOnlySecrets(SecretBuildSource... secrets) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given SecretBuildSource varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's secrets does not contain the given SecretBuildSource elements.
   *
   * @param secrets the given elements that should not be in actual BuildSourceFluent's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildSourceFluent's secrets contains any given SecretBuildSource elements.
   */
  public S doesNotHaveSecrets(SecretBuildSource... secrets) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given SecretBuildSource varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent has no secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildSourceFluent's secrets is not empty.
   */
  public S hasNoSecrets() {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have secrets but had :\n  <%s>";
    
    // check
    if (actual.getSecrets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSecrets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual BuildSourceFluent's sourceSecret is equal to the given one.
   * @param sourceSecret the given sourceSecret to compare the actual BuildSourceFluent's sourceSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluent's sourceSecret is not equal to the given one.
   */
  public S hasSourceSecret(io.fabric8.kubernetes.api.model.LocalObjectReference sourceSecret) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting sourceSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualSourceSecret = actual.getSourceSecret();
    if (!Objects.areEqual(actualSourceSecret, sourceSecret)) {
      failWithMessage(assertjErrorMessage, actual, sourceSecret, actualSourceSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSourceFluent's type is equal to the given one.
   * @param type the given type to compare the actual BuildSourceFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSourceFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual BuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
