package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LabelSelector} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLabelSelectorAssert<S extends AbstractLabelSelectorAssert<S, A>, A extends LabelSelector> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLabelSelectorAssert}</code> to make assertions on actual LabelSelector.
   * @param actual the LabelSelector we want to make assertions on.
   */
  protected AbstractLabelSelectorAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LabelSelector's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LabelSelector's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LabelSelector's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LabelSelector we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LabelSelector's matchExpressions contains the given LabelSelectorRequirement elements.
   * @param matchExpressions the given elements that should be contained in actual LabelSelector's matchExpressions.
   * @return this assertion object.
   * @throws AssertionError if the actual LabelSelector's matchExpressions does not contain all given LabelSelectorRequirement elements.
   */
  public S hasMatchExpressions(LabelSelectorRequirement... matchExpressions) {
    // check that actual LabelSelector we want to make assertions on is not null.
    isNotNull();

    // check that given LabelSelectorRequirement varargs is not null.
    if (matchExpressions == null) failWithMessage("Expecting matchExpressions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getMatchExpressions(), matchExpressions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LabelSelector's matchExpressions contains <b>only<b> the given LabelSelectorRequirement elements and nothing else in whatever order.
   * @param matchExpressions the given elements that should be contained in actual LabelSelector's matchExpressions.
   * @return this assertion object.
   * @throws AssertionError if the actual LabelSelector's matchExpressions does not contain all given LabelSelectorRequirement elements.
   */
  public S hasOnlyMatchExpressions(LabelSelectorRequirement... matchExpressions) {
    // check that actual LabelSelector we want to make assertions on is not null.
    isNotNull();

    // check that given LabelSelectorRequirement varargs is not null.
    if (matchExpressions == null) failWithMessage("Expecting matchExpressions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getMatchExpressions(), matchExpressions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LabelSelector's matchExpressions does not contain the given LabelSelectorRequirement elements.
   *
   * @param matchExpressions the given elements that should not be in actual LabelSelector's matchExpressions.
   * @return this assertion object.
   * @throws AssertionError if the actual LabelSelector's matchExpressions contains any given LabelSelectorRequirement elements.
   */
  public S doesNotHaveMatchExpressions(LabelSelectorRequirement... matchExpressions) {
    // check that actual LabelSelector we want to make assertions on is not null.
    isNotNull();

    // check that given LabelSelectorRequirement varargs is not null.
    if (matchExpressions == null) failWithMessage("Expecting matchExpressions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getMatchExpressions(), matchExpressions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LabelSelector has no matchExpressions.
   * @return this assertion object.
   * @throws AssertionError if the actual LabelSelector's matchExpressions is not empty.
   */
  public S hasNoMatchExpressions() {
    // check that actual LabelSelector we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have matchExpressions but had :\n  <%s>";
    
    // check
    if (actual.getMatchExpressions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getMatchExpressions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual LabelSelector's matchLabels is equal to the given one.
   * @param matchLabels the given matchLabels to compare the actual LabelSelector's matchLabels to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LabelSelector's matchLabels is not equal to the given one.
   */
  public S hasMatchLabels(java.util.Map matchLabels) {
    // check that actual LabelSelector we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting matchLabels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualMatchLabels = actual.getMatchLabels();
    if (!Objects.areEqual(actualMatchLabels, matchLabels)) {
      failWithMessage(assertjErrorMessage, actual, matchLabels, actualMatchLabels);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
