package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HTTPIngressPathFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHTTPIngressPathFluentAssert<S extends AbstractHTTPIngressPathFluentAssert<S, A>, A extends HTTPIngressPathFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHTTPIngressPathFluentAssert}</code> to make assertions on actual HTTPIngressPathFluent.
   * @param actual the HTTPIngressPathFluent we want to make assertions on.
   */
  protected AbstractHTTPIngressPathFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HTTPIngressPathFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual HTTPIngressPathFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPIngressPathFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual HTTPIngressPathFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPIngressPathFluent's backend is equal to the given one.
   * @param backend the given backend to compare the actual HTTPIngressPathFluent's backend to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPIngressPathFluent's backend is not equal to the given one.
   */
  public S hasBackend(IngressBackend backend) {
    // check that actual HTTPIngressPathFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting backend of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    IngressBackend actualBackend = actual.getBackend();
    if (!Objects.areEqual(actualBackend, backend)) {
      failWithMessage(assertjErrorMessage, actual, backend, actualBackend);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPIngressPathFluent's path is equal to the given one.
   * @param path the given path to compare the actual HTTPIngressPathFluent's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPIngressPathFluent's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual HTTPIngressPathFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
