package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DaemonSetSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDaemonSetSpecFluentImplAssert<S extends AbstractDaemonSetSpecFluentImplAssert<S, A>, A extends DaemonSetSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDaemonSetSpecFluentImplAssert}</code> to make assertions on actual DaemonSetSpecFluentImpl.
   * @param actual the DaemonSetSpecFluentImpl we want to make assertions on.
   */
  protected AbstractDaemonSetSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DaemonSetSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DaemonSetSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DaemonSetSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetSpecFluentImpl's selector is equal to the given one.
   * @param selector the given selector to compare the actual DaemonSetSpecFluentImpl's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpecFluentImpl's selector is not equal to the given one.
   */
  public S hasSelector(LabelSelector selector) {
    // check that actual DaemonSetSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LabelSelector actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetSpecFluentImpl's template is equal to the given one.
   * @param template the given template to compare the actual DaemonSetSpecFluentImpl's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpecFluentImpl's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    // check that actual DaemonSetSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetSpecFluentImpl's uniqueLabelKey is equal to the given one.
   * @param uniqueLabelKey the given uniqueLabelKey to compare the actual DaemonSetSpecFluentImpl's uniqueLabelKey to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpecFluentImpl's uniqueLabelKey is not equal to the given one.
   */
  public S hasUniqueLabelKey(String uniqueLabelKey) {
    // check that actual DaemonSetSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting uniqueLabelKey of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUniqueLabelKey = actual.getUniqueLabelKey();
    if (!Objects.areEqual(actualUniqueLabelKey, uniqueLabelKey)) {
      failWithMessage(assertjErrorMessage, actual, uniqueLabelKey, actualUniqueLabelKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetSpecFluentImpl's updateStrategy is equal to the given one.
   * @param updateStrategy the given updateStrategy to compare the actual DaemonSetSpecFluentImpl's updateStrategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetSpecFluentImpl's updateStrategy is not equal to the given one.
   */
  public S hasUpdateStrategy(DaemonSetUpdateStrategy updateStrategy) {
    // check that actual DaemonSetSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting updateStrategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DaemonSetUpdateStrategy actualUpdateStrategy = actual.getUpdateStrategy();
    if (!Objects.areEqual(actualUpdateStrategy, updateStrategy)) {
      failWithMessage(assertjErrorMessage, actual, updateStrategy, actualUpdateStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
