package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ConfigMapFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigMapFluentAssert<S extends AbstractConfigMapFluentAssert<S, A>, A extends ConfigMapFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigMapFluentAssert}</code> to make assertions on actual ConfigMapFluent.
   * @param actual the ConfigMapFluent we want to make assertions on.
   */
  protected AbstractConfigMapFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ConfigMapFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ConfigMapFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ConfigMapFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ConfigMapFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ConfigMap.ApiVersion apiVersion) {
    // check that actual ConfigMapFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ConfigMap.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapFluent's data is equal to the given one.
   * @param data the given data to compare the actual ConfigMapFluent's data to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapFluent's data is not equal to the given one.
   */
  public S hasData(java.util.Map data) {
    // check that actual ConfigMapFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting data of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualData = actual.getData();
    if (!Objects.areEqual(actualData, data)) {
      failWithMessage(assertjErrorMessage, actual, data, actualData);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual ConfigMapFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ConfigMapFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ConfigMapFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual ConfigMapFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
