package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NodeStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNodeStatusFluentImplAssert<S extends AbstractNodeStatusFluentImplAssert<S, A>, A extends NodeStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNodeStatusFluentImplAssert}</code> to make assertions on actual NodeStatusFluentImpl.
   * @param actual the NodeStatusFluentImpl we want to make assertions on.
   */
  protected AbstractNodeStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NodeStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's addresses contains the given NodeAddress elements.
   * @param addresses the given elements that should be contained in actual NodeStatusFluentImpl's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's addresses does not contain all given NodeAddress elements.
   */
  public S hasAddresses(NodeAddress... addresses) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NodeAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's addresses contains <b>only<b> the given NodeAddress elements and nothing else in whatever order.
   * @param addresses the given elements that should be contained in actual NodeStatusFluentImpl's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's addresses does not contain all given NodeAddress elements.
   */
  public S hasOnlyAddresses(NodeAddress... addresses) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NodeAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's addresses does not contain the given NodeAddress elements.
   *
   * @param addresses the given elements that should not be in actual NodeStatusFluentImpl's addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's addresses contains any given NodeAddress elements.
   */
  public S doesNotHaveAddresses(NodeAddress... addresses) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NodeAddress varargs is not null.
    if (addresses == null) failWithMessage("Expecting addresses parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getAddresses(), addresses);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl has no addresses.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's addresses is not empty.
   */
  public S hasNoAddresses() {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have addresses but had :\n  <%s>";
    
    // check
    if (actual.getAddresses().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getAddresses());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NodeStatusFluentImpl's allocatable is equal to the given one.
   * @param allocatable the given allocatable to compare the actual NodeStatusFluentImpl's allocatable to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluentImpl's allocatable is not equal to the given one.
   */
  public S hasAllocatable(java.util.Map allocatable) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting allocatable of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAllocatable = actual.getAllocatable();
    if (!Objects.areEqual(actualAllocatable, allocatable)) {
      failWithMessage(assertjErrorMessage, actual, allocatable, actualAllocatable);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's capacity is equal to the given one.
   * @param capacity the given capacity to compare the actual NodeStatusFluentImpl's capacity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluentImpl's capacity is not equal to the given one.
   */
  public S hasCapacity(java.util.Map capacity) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting capacity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualCapacity = actual.getCapacity();
    if (!Objects.areEqual(actualCapacity, capacity)) {
      failWithMessage(assertjErrorMessage, actual, capacity, actualCapacity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's conditions contains the given NodeCondition elements.
   * @param conditions the given elements that should be contained in actual NodeStatusFluentImpl's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's conditions does not contain all given NodeCondition elements.
   */
  public S hasConditions(NodeCondition... conditions) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NodeCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's conditions contains <b>only<b> the given NodeCondition elements and nothing else in whatever order.
   * @param conditions the given elements that should be contained in actual NodeStatusFluentImpl's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's conditions does not contain all given NodeCondition elements.
   */
  public S hasOnlyConditions(NodeCondition... conditions) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NodeCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's conditions does not contain the given NodeCondition elements.
   *
   * @param conditions the given elements that should not be in actual NodeStatusFluentImpl's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's conditions contains any given NodeCondition elements.
   */
  public S doesNotHaveConditions(NodeCondition... conditions) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given NodeCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NodeStatusFluentImpl's daemonEndpoints is equal to the given one.
   * @param daemonEndpoints the given daemonEndpoints to compare the actual NodeStatusFluentImpl's daemonEndpoints to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluentImpl's daemonEndpoints is not equal to the given one.
   */
  public S hasDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting daemonEndpoints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeDaemonEndpoints actualDaemonEndpoints = actual.getDaemonEndpoints();
    if (!Objects.areEqual(actualDaemonEndpoints, daemonEndpoints)) {
      failWithMessage(assertjErrorMessage, actual, daemonEndpoints, actualDaemonEndpoints);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's images contains the given ContainerImage elements.
   * @param images the given elements that should be contained in actual NodeStatusFluentImpl's images.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's images does not contain all given ContainerImage elements.
   */
  public S hasImages(ContainerImage... images) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerImage varargs is not null.
    if (images == null) failWithMessage("Expecting images parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getImages(), images);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's images contains <b>only<b> the given ContainerImage elements and nothing else in whatever order.
   * @param images the given elements that should be contained in actual NodeStatusFluentImpl's images.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's images does not contain all given ContainerImage elements.
   */
  public S hasOnlyImages(ContainerImage... images) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerImage varargs is not null.
    if (images == null) failWithMessage("Expecting images parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getImages(), images);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's images does not contain the given ContainerImage elements.
   *
   * @param images the given elements that should not be in actual NodeStatusFluentImpl's images.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's images contains any given ContainerImage elements.
   */
  public S doesNotHaveImages(ContainerImage... images) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given ContainerImage varargs is not null.
    if (images == null) failWithMessage("Expecting images parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getImages(), images);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl has no images.
   * @return this assertion object.
   * @throws AssertionError if the actual NodeStatusFluentImpl's images is not empty.
   */
  public S hasNoImages() {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have images but had :\n  <%s>";
    
    // check
    if (actual.getImages().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getImages());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual NodeStatusFluentImpl's nodeInfo is equal to the given one.
   * @param nodeInfo the given nodeInfo to compare the actual NodeStatusFluentImpl's nodeInfo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluentImpl's nodeInfo is not equal to the given one.
   */
  public S hasNodeInfo(NodeSystemInfo nodeInfo) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting nodeInfo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeSystemInfo actualNodeInfo = actual.getNodeInfo();
    if (!Objects.areEqual(actualNodeInfo, nodeInfo)) {
      failWithMessage(assertjErrorMessage, actual, nodeInfo, actualNodeInfo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NodeStatusFluentImpl's phase is equal to the given one.
   * @param phase the given phase to compare the actual NodeStatusFluentImpl's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NodeStatusFluentImpl's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual NodeStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
