package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LimitRangeSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLimitRangeSpecFluentImplAssert<S extends AbstractLimitRangeSpecFluentImplAssert<S, A>, A extends LimitRangeSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLimitRangeSpecFluentImplAssert}</code> to make assertions on actual LimitRangeSpecFluentImpl.
   * @param actual the LimitRangeSpecFluentImpl we want to make assertions on.
   */
  protected AbstractLimitRangeSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LimitRangeSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LimitRangeSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LimitRangeSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LimitRangeSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LimitRangeSpecFluentImpl's limits contains the given LimitRangeItem elements.
   * @param limits the given elements that should be contained in actual LimitRangeSpecFluentImpl's limits.
   * @return this assertion object.
   * @throws AssertionError if the actual LimitRangeSpecFluentImpl's limits does not contain all given LimitRangeItem elements.
   */
  public S hasLimits(LimitRangeItem... limits) {
    // check that actual LimitRangeSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given LimitRangeItem varargs is not null.
    if (limits == null) failWithMessage("Expecting limits parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getLimits(), limits);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LimitRangeSpecFluentImpl's limits contains <b>only<b> the given LimitRangeItem elements and nothing else in whatever order.
   * @param limits the given elements that should be contained in actual LimitRangeSpecFluentImpl's limits.
   * @return this assertion object.
   * @throws AssertionError if the actual LimitRangeSpecFluentImpl's limits does not contain all given LimitRangeItem elements.
   */
  public S hasOnlyLimits(LimitRangeItem... limits) {
    // check that actual LimitRangeSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given LimitRangeItem varargs is not null.
    if (limits == null) failWithMessage("Expecting limits parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getLimits(), limits);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LimitRangeSpecFluentImpl's limits does not contain the given LimitRangeItem elements.
   *
   * @param limits the given elements that should not be in actual LimitRangeSpecFluentImpl's limits.
   * @return this assertion object.
   * @throws AssertionError if the actual LimitRangeSpecFluentImpl's limits contains any given LimitRangeItem elements.
   */
  public S doesNotHaveLimits(LimitRangeItem... limits) {
    // check that actual LimitRangeSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given LimitRangeItem varargs is not null.
    if (limits == null) failWithMessage("Expecting limits parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getLimits(), limits);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LimitRangeSpecFluentImpl has no limits.
   * @return this assertion object.
   * @throws AssertionError if the actual LimitRangeSpecFluentImpl's limits is not empty.
   */
  public S hasNoLimits() {
    // check that actual LimitRangeSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have limits but had :\n  <%s>";
    
    // check
    if (actual.getLimits().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getLimits());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
