package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerImageFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerImageFluentAssert<S extends AbstractContainerImageFluentAssert<S, A>, A extends ContainerImageFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerImageFluentAssert}</code> to make assertions on actual ContainerImageFluent.
   * @param actual the ContainerImageFluent we want to make assertions on.
   */
  protected AbstractContainerImageFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerImageFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerImageFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerImageFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerImageFluent's repoTags contains the given String elements.
   * @param repoTags the given elements that should be contained in actual ContainerImageFluent's repoTags.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerImageFluent's repoTags does not contain all given String elements.
   */
  public S hasRepoTags(String... repoTags) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (repoTags == null) failWithMessage("Expecting repoTags parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRepoTags(), repoTags);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerImageFluent's repoTags contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param repoTags the given elements that should be contained in actual ContainerImageFluent's repoTags.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerImageFluent's repoTags does not contain all given String elements.
   */
  public S hasOnlyRepoTags(String... repoTags) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (repoTags == null) failWithMessage("Expecting repoTags parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getRepoTags(), repoTags);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerImageFluent's repoTags does not contain the given String elements.
   *
   * @param repoTags the given elements that should not be in actual ContainerImageFluent's repoTags.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerImageFluent's repoTags contains any given String elements.
   */
  public S doesNotHaveRepoTags(String... repoTags) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (repoTags == null) failWithMessage("Expecting repoTags parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getRepoTags(), repoTags);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerImageFluent has no repoTags.
   * @return this assertion object.
   * @throws AssertionError if the actual ContainerImageFluent's repoTags is not empty.
   */
  public S hasNoRepoTags() {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have repoTags but had :\n  <%s>";
    
    // check
    if (actual.getRepoTags().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRepoTags());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ContainerImageFluent's size is equal to the given one.
   * @param size the given size to compare the actual ContainerImageFluent's size to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerImageFluent's size is not equal to the given one.
   */
  public S hasSize(Long size) {
    // check that actual ContainerImageFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting size of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualSize = actual.getSize();
    if (!Objects.areEqual(actualSize, size)) {
      failWithMessage(assertjErrorMessage, actual, size, actualSize);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
