package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ImageLayerFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageLayerFluentAssert<S extends AbstractImageLayerFluentAssert<S, A>, A extends ImageLayerFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageLayerFluentAssert}</code> to make assertions on actual ImageLayerFluent.
   * @param actual the ImageLayerFluent we want to make assertions on.
   */
  protected AbstractImageLayerFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ImageLayerFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ImageLayerFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageLayerFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ImageLayerFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageLayerFluent's name is equal to the given one.
   * @param name the given name to compare the actual ImageLayerFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageLayerFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual ImageLayerFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ImageLayerFluent's size is equal to the given one.
   * @param size the given size to compare the actual ImageLayerFluent's size to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ImageLayerFluent's size is not equal to the given one.
   */
  public S hasSize(Long size) {
    // check that actual ImageLayerFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting size of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualSize = actual.getSize();
    if (!Objects.areEqual(actualSize, size)) {
      failWithMessage(assertjErrorMessage, actual, size, actualSize);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
