package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DockerBuildStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDockerBuildStrategyAssert<S extends AbstractDockerBuildStrategyAssert<S, A>, A extends DockerBuildStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDockerBuildStrategyAssert}</code> to make assertions on actual DockerBuildStrategy.
   * @param actual the DockerBuildStrategy we want to make assertions on.
   */
  protected AbstractDockerBuildStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DockerBuildStrategy's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DockerBuildStrategy's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerBuildStrategy's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerBuildStrategy's dockerfilePath is equal to the given one.
   * @param dockerfilePath the given dockerfilePath to compare the actual DockerBuildStrategy's dockerfilePath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerBuildStrategy's dockerfilePath is not equal to the given one.
   */
  public S hasDockerfilePath(String dockerfilePath) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerfilePath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerfilePath = actual.getDockerfilePath();
    if (!Objects.areEqual(actualDockerfilePath, dockerfilePath)) {
      failWithMessage(assertjErrorMessage, actual, dockerfilePath, actualDockerfilePath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerBuildStrategy's env contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param env the given elements that should be contained in actual DockerBuildStrategy's env.
   * @return this assertion object.
   * @throws AssertionError if the actual DockerBuildStrategy's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerBuildStrategy's env contains <b>only<b> the given io.fabric8.kubernetes.api.model.EnvVar elements and nothing else in whatever order.
   * @param env the given elements that should be contained in actual DockerBuildStrategy's env.
   * @return this assertion object.
   * @throws AssertionError if the actual DockerBuildStrategy's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasOnlyEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerBuildStrategy's env does not contain the given io.fabric8.kubernetes.api.model.EnvVar elements.
   *
   * @param env the given elements that should not be in actual DockerBuildStrategy's env.
   * @return this assertion object.
   * @throws AssertionError if the actual DockerBuildStrategy's env contains any given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S doesNotHaveEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerBuildStrategy has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual DockerBuildStrategy's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual DockerBuildStrategy's forcePull is equal to the given one.
   * @param forcePull the given forcePull to compare the actual DockerBuildStrategy's forcePull to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerBuildStrategy's forcePull is not equal to the given one.
   */
  public S hasForcePull(Boolean forcePull) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting forcePull of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualForcePull = actual.getForcePull();
    if (!Objects.areEqual(actualForcePull, forcePull)) {
      failWithMessage(assertjErrorMessage, actual, forcePull, actualForcePull);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerBuildStrategy's from is equal to the given one.
   * @param from the given from to compare the actual DockerBuildStrategy's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerBuildStrategy's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerBuildStrategy's noCache is equal to the given one.
   * @param noCache the given noCache to compare the actual DockerBuildStrategy's noCache to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerBuildStrategy's noCache is not equal to the given one.
   */
  public S hasNoCache(Boolean noCache) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting noCache of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualNoCache = actual.getNoCache();
    if (!Objects.areEqual(actualNoCache, noCache)) {
      failWithMessage(assertjErrorMessage, actual, noCache, actualNoCache);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DockerBuildStrategy's pullSecret is equal to the given one.
   * @param pullSecret the given pullSecret to compare the actual DockerBuildStrategy's pullSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DockerBuildStrategy's pullSecret is not equal to the given one.
   */
  public S hasPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    // check that actual DockerBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting pullSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualPullSecret = actual.getPullSecret();
    if (!Objects.areEqual(actualPullSecret, pullSecret)) {
      failWithMessage(assertjErrorMessage, actual, pullSecret, actualPullSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
