package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentConfigSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentConfigSpecFluentAssert<S extends AbstractDeploymentConfigSpecFluentAssert<S, A>, A extends DeploymentConfigSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentConfigSpecFluentAssert}</code> to make assertions on actual DeploymentConfigSpecFluent.
   * @param actual the DeploymentConfigSpecFluent we want to make assertions on.
   */
  protected AbstractDeploymentConfigSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentConfigSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual DeploymentConfigSpecFluent's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluent's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent's selector is equal to the given one.
   * @param selector the given selector to compare the actual DeploymentConfigSpecFluent's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluent's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent's strategy is equal to the given one.
   * @param strategy the given strategy to compare the actual DeploymentConfigSpecFluent's strategy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluent's strategy is not equal to the given one.
   */
  public S hasStrategy(DeploymentStrategy strategy) {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting strategy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeploymentStrategy actualStrategy = actual.getStrategy();
    if (!Objects.areEqual(actualStrategy, strategy)) {
      failWithMessage(assertjErrorMessage, actual, strategy, actualStrategy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent's template is equal to the given one.
   * @param template the given template to compare the actual DeploymentConfigSpecFluent's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigSpecFluent's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.PodTemplateSpec actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent's triggers contains the given DeploymentTriggerPolicy elements.
   * @param triggers the given elements that should be contained in actual DeploymentConfigSpecFluent's triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentConfigSpecFluent's triggers does not contain all given DeploymentTriggerPolicy elements.
   */
  public S hasTriggers(DeploymentTriggerPolicy... triggers) {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given DeploymentTriggerPolicy varargs is not null.
    if (triggers == null) failWithMessage("Expecting triggers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getTriggers(), triggers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent's triggers contains <b>only<b> the given DeploymentTriggerPolicy elements and nothing else in whatever order.
   * @param triggers the given elements that should be contained in actual DeploymentConfigSpecFluent's triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentConfigSpecFluent's triggers does not contain all given DeploymentTriggerPolicy elements.
   */
  public S hasOnlyTriggers(DeploymentTriggerPolicy... triggers) {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given DeploymentTriggerPolicy varargs is not null.
    if (triggers == null) failWithMessage("Expecting triggers parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getTriggers(), triggers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent's triggers does not contain the given DeploymentTriggerPolicy elements.
   *
   * @param triggers the given elements that should not be in actual DeploymentConfigSpecFluent's triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentConfigSpecFluent's triggers contains any given DeploymentTriggerPolicy elements.
   */
  public S doesNotHaveTriggers(DeploymentTriggerPolicy... triggers) {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given DeploymentTriggerPolicy varargs is not null.
    if (triggers == null) failWithMessage("Expecting triggers parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getTriggers(), triggers);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigSpecFluent has no triggers.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentConfigSpecFluent's triggers is not empty.
   */
  public S hasNoTriggers() {
    // check that actual DeploymentConfigSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have triggers but had :\n  <%s>";
    
    // check
    if (actual.getTriggers().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getTriggers());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
