package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildPostCommitSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildPostCommitSpecFluentImplAssert<S extends AbstractBuildPostCommitSpecFluentImplAssert<S, A>, A extends BuildPostCommitSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildPostCommitSpecFluentImplAssert}</code> to make assertions on actual BuildPostCommitSpecFluentImpl.
   * @param actual the BuildPostCommitSpecFluentImpl we want to make assertions on.
   */
  protected AbstractBuildPostCommitSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildPostCommitSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildPostCommitSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl's args contains the given String elements.
   * @param args the given elements that should be contained in actual BuildPostCommitSpecFluentImpl's args.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildPostCommitSpecFluentImpl's args does not contain all given String elements.
   */
  public S hasArgs(String... args) {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (args == null) failWithMessage("Expecting args parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getArgs(), args);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl's args contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param args the given elements that should be contained in actual BuildPostCommitSpecFluentImpl's args.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildPostCommitSpecFluentImpl's args does not contain all given String elements.
   */
  public S hasOnlyArgs(String... args) {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (args == null) failWithMessage("Expecting args parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getArgs(), args);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl's args does not contain the given String elements.
   *
   * @param args the given elements that should not be in actual BuildPostCommitSpecFluentImpl's args.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildPostCommitSpecFluentImpl's args contains any given String elements.
   */
  public S doesNotHaveArgs(String... args) {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (args == null) failWithMessage("Expecting args parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getArgs(), args);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl has no args.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildPostCommitSpecFluentImpl's args is not empty.
   */
  public S hasNoArgs() {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have args but had :\n  <%s>";
    
    // check
    if (actual.getArgs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getArgs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl's command contains the given String elements.
   * @param command the given elements that should be contained in actual BuildPostCommitSpecFluentImpl's command.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildPostCommitSpecFluentImpl's command does not contain all given String elements.
   */
  public S hasCommand(String... command) {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl's command contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param command the given elements that should be contained in actual BuildPostCommitSpecFluentImpl's command.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildPostCommitSpecFluentImpl's command does not contain all given String elements.
   */
  public S hasOnlyCommand(String... command) {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl's command does not contain the given String elements.
   *
   * @param command the given elements that should not be in actual BuildPostCommitSpecFluentImpl's command.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildPostCommitSpecFluentImpl's command contains any given String elements.
   */
  public S doesNotHaveCommand(String... command) {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (command == null) failWithMessage("Expecting command parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getCommand(), command);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl has no command.
   * @return this assertion object.
   * @throws AssertionError if the actual BuildPostCommitSpecFluentImpl's command is not empty.
   */
  public S hasNoCommand() {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have command but had :\n  <%s>";
    
    // check
    if (actual.getCommand().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCommand());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual BuildPostCommitSpecFluentImpl's script is equal to the given one.
   * @param script the given script to compare the actual BuildPostCommitSpecFluentImpl's script to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildPostCommitSpecFluentImpl's script is not equal to the given one.
   */
  public S hasScript(String script) {
    // check that actual BuildPostCommitSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting script of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualScript = actual.getScript();
    if (!Objects.areEqual(actualScript, script)) {
      failWithMessage(assertjErrorMessage, actual, script, actualScript);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
