package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ConfigMapList} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractConfigMapListAssert<S extends AbstractConfigMapListAssert<S, A>, A extends ConfigMapList> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractConfigMapListAssert}</code> to make assertions on actual ConfigMapList.
   * @param actual the ConfigMapList we want to make assertions on.
   */
  protected AbstractConfigMapListAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ConfigMapList's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ConfigMapList's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapList's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ConfigMapList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapList's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual ConfigMapList's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapList's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(ConfigMapList.ApiVersion apiVersion) {
    // check that actual ConfigMapList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ConfigMapList.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapList's items contains the given ConfigMap elements.
   * @param items the given elements that should be contained in actual ConfigMapList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigMapList's items does not contain all given ConfigMap elements.
   */
  public S hasItems(ConfigMap... items) {
    // check that actual ConfigMapList we want to make assertions on is not null.
    isNotNull();

    // check that given ConfigMap varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapList's items contains <b>only<b> the given ConfigMap elements and nothing else in whatever order.
   * @param items the given elements that should be contained in actual ConfigMapList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigMapList's items does not contain all given ConfigMap elements.
   */
  public S hasOnlyItems(ConfigMap... items) {
    // check that actual ConfigMapList we want to make assertions on is not null.
    isNotNull();

    // check that given ConfigMap varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapList's items does not contain the given ConfigMap elements.
   *
   * @param items the given elements that should not be in actual ConfigMapList's items.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigMapList's items contains any given ConfigMap elements.
   */
  public S doesNotHaveItems(ConfigMap... items) {
    // check that actual ConfigMapList we want to make assertions on is not null.
    isNotNull();

    // check that given ConfigMap varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapList has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual ConfigMapList's items is not empty.
   */
  public S hasNoItems() {
    // check that actual ConfigMapList we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ConfigMapList's kind is equal to the given one.
   * @param kind the given kind to compare the actual ConfigMapList's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapList's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual ConfigMapList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ConfigMapList's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual ConfigMapList's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ConfigMapList's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ListMeta metadata) {
    // check that actual ConfigMapList we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ListMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
