package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Volume} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeAssert<S extends AbstractVolumeAssert<S, A>, A extends Volume> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeAssert}</code> to make assertions on actual Volume.
   * @param actual the Volume we want to make assertions on.
   */
  protected AbstractVolumeAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Volume's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Volume's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's awsElasticBlockStore is equal to the given one.
   * @param awsElasticBlockStore the given awsElasticBlockStore to compare the actual Volume's awsElasticBlockStore to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's awsElasticBlockStore is not equal to the given one.
   */
  public S hasAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting awsElasticBlockStore of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    AWSElasticBlockStoreVolumeSource actualAwsElasticBlockStore = actual.getAwsElasticBlockStore();
    if (!Objects.areEqual(actualAwsElasticBlockStore, awsElasticBlockStore)) {
      failWithMessage(assertjErrorMessage, actual, awsElasticBlockStore, actualAwsElasticBlockStore);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's cephfs is equal to the given one.
   * @param cephfs the given cephfs to compare the actual Volume's cephfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's cephfs is not equal to the given one.
   */
  public S hasCephfs(CephFSVolumeSource cephfs) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cephfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CephFSVolumeSource actualCephfs = actual.getCephfs();
    if (!Objects.areEqual(actualCephfs, cephfs)) {
      failWithMessage(assertjErrorMessage, actual, cephfs, actualCephfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's cinder is equal to the given one.
   * @param cinder the given cinder to compare the actual Volume's cinder to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's cinder is not equal to the given one.
   */
  public S hasCinder(CinderVolumeSource cinder) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting cinder of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CinderVolumeSource actualCinder = actual.getCinder();
    if (!Objects.areEqual(actualCinder, cinder)) {
      failWithMessage(assertjErrorMessage, actual, cinder, actualCinder);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's downwardAPI is equal to the given one.
   * @param downwardAPI the given downwardAPI to compare the actual Volume's downwardAPI to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's downwardAPI is not equal to the given one.
   */
  public S hasDownwardAPI(DownwardAPIVolumeSource downwardAPI) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting downwardAPI of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DownwardAPIVolumeSource actualDownwardAPI = actual.getDownwardAPI();
    if (!Objects.areEqual(actualDownwardAPI, downwardAPI)) {
      failWithMessage(assertjErrorMessage, actual, downwardAPI, actualDownwardAPI);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's emptyDir is equal to the given one.
   * @param emptyDir the given emptyDir to compare the actual Volume's emptyDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's emptyDir is not equal to the given one.
   */
  public S hasEmptyDir(EmptyDirVolumeSource emptyDir) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting emptyDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EmptyDirVolumeSource actualEmptyDir = actual.getEmptyDir();
    if (!Objects.areEqual(actualEmptyDir, emptyDir)) {
      failWithMessage(assertjErrorMessage, actual, emptyDir, actualEmptyDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's fc is equal to the given one.
   * @param fc the given fc to compare the actual Volume's fc to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's fc is not equal to the given one.
   */
  public S hasFc(FCVolumeSource fc) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fc of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    FCVolumeSource actualFc = actual.getFc();
    if (!Objects.areEqual(actualFc, fc)) {
      failWithMessage(assertjErrorMessage, actual, fc, actualFc);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's flexVolume is equal to the given one.
   * @param flexVolume the given flexVolume to compare the actual Volume's flexVolume to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's flexVolume is not equal to the given one.
   */
  public S hasFlexVolume(FlexVolumeSource flexVolume) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting flexVolume of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    FlexVolumeSource actualFlexVolume = actual.getFlexVolume();
    if (!Objects.areEqual(actualFlexVolume, flexVolume)) {
      failWithMessage(assertjErrorMessage, actual, flexVolume, actualFlexVolume);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's flocker is equal to the given one.
   * @param flocker the given flocker to compare the actual Volume's flocker to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's flocker is not equal to the given one.
   */
  public S hasFlocker(FlockerVolumeSource flocker) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting flocker of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    FlockerVolumeSource actualFlocker = actual.getFlocker();
    if (!Objects.areEqual(actualFlocker, flocker)) {
      failWithMessage(assertjErrorMessage, actual, flocker, actualFlocker);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's gcePersistentDisk is equal to the given one.
   * @param gcePersistentDisk the given gcePersistentDisk to compare the actual Volume's gcePersistentDisk to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's gcePersistentDisk is not equal to the given one.
   */
  public S hasGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting gcePersistentDisk of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GCEPersistentDiskVolumeSource actualGcePersistentDisk = actual.getGcePersistentDisk();
    if (!Objects.areEqual(actualGcePersistentDisk, gcePersistentDisk)) {
      failWithMessage(assertjErrorMessage, actual, gcePersistentDisk, actualGcePersistentDisk);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's gitRepo is equal to the given one.
   * @param gitRepo the given gitRepo to compare the actual Volume's gitRepo to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's gitRepo is not equal to the given one.
   */
  public S hasGitRepo(GitRepoVolumeSource gitRepo) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting gitRepo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitRepoVolumeSource actualGitRepo = actual.getGitRepo();
    if (!Objects.areEqual(actualGitRepo, gitRepo)) {
      failWithMessage(assertjErrorMessage, actual, gitRepo, actualGitRepo);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's glusterfs is equal to the given one.
   * @param glusterfs the given glusterfs to compare the actual Volume's glusterfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's glusterfs is not equal to the given one.
   */
  public S hasGlusterfs(GlusterfsVolumeSource glusterfs) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting glusterfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GlusterfsVolumeSource actualGlusterfs = actual.getGlusterfs();
    if (!Objects.areEqual(actualGlusterfs, glusterfs)) {
      failWithMessage(assertjErrorMessage, actual, glusterfs, actualGlusterfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's hostPath is equal to the given one.
   * @param hostPath the given hostPath to compare the actual Volume's hostPath to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's hostPath is not equal to the given one.
   */
  public S hasHostPath(HostPathVolumeSource hostPath) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting hostPath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HostPathVolumeSource actualHostPath = actual.getHostPath();
    if (!Objects.areEqual(actualHostPath, hostPath)) {
      failWithMessage(assertjErrorMessage, actual, hostPath, actualHostPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's iscsi is equal to the given one.
   * @param iscsi the given iscsi to compare the actual Volume's iscsi to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's iscsi is not equal to the given one.
   */
  public S hasIscsi(ISCSIVolumeSource iscsi) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting iscsi of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ISCSIVolumeSource actualIscsi = actual.getIscsi();
    if (!Objects.areEqual(actualIscsi, iscsi)) {
      failWithMessage(assertjErrorMessage, actual, iscsi, actualIscsi);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual Volume's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's metadata is not equal to the given one.
   */
  public S hasMetadata(MetadataVolumeSource metadata) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    MetadataVolumeSource actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's name is equal to the given one.
   * @param name the given name to compare the actual Volume's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's nfs is equal to the given one.
   * @param nfs the given nfs to compare the actual Volume's nfs to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's nfs is not equal to the given one.
   */
  public S hasNfs(NFSVolumeSource nfs) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting nfs of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NFSVolumeSource actualNfs = actual.getNfs();
    if (!Objects.areEqual(actualNfs, nfs)) {
      failWithMessage(assertjErrorMessage, actual, nfs, actualNfs);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's persistentVolumeClaim is equal to the given one.
   * @param persistentVolumeClaim the given persistentVolumeClaim to compare the actual Volume's persistentVolumeClaim to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's persistentVolumeClaim is not equal to the given one.
   */
  public S hasPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting persistentVolumeClaim of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaimVolumeSource actualPersistentVolumeClaim = actual.getPersistentVolumeClaim();
    if (!Objects.areEqual(actualPersistentVolumeClaim, persistentVolumeClaim)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeClaim, actualPersistentVolumeClaim);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's rbd is equal to the given one.
   * @param rbd the given rbd to compare the actual Volume's rbd to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's rbd is not equal to the given one.
   */
  public S hasRbd(RBDVolumeSource rbd) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rbd of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RBDVolumeSource actualRbd = actual.getRbd();
    if (!Objects.areEqual(actualRbd, rbd)) {
      failWithMessage(assertjErrorMessage, actual, rbd, actualRbd);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual Volume's secret is equal to the given one.
   * @param secret the given secret to compare the actual Volume's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Volume's secret is not equal to the given one.
   */
  public S hasSecret(SecretVolumeSource secret) {
    // check that actual Volume we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecretVolumeSource actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
