package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ISCSIVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractISCSIVolumeSourceAssert<S extends AbstractISCSIVolumeSourceAssert<S, A>, A extends ISCSIVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractISCSIVolumeSourceAssert}</code> to make assertions on actual ISCSIVolumeSource.
   * @param actual the ISCSIVolumeSource we want to make assertions on.
   */
  protected AbstractISCSIVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ISCSIVolumeSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ISCSIVolumeSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSource's fsType is equal to the given one.
   * @param fsType the given fsType to compare the actual ISCSIVolumeSource's fsType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSource's fsType is not equal to the given one.
   */
  public S hasFsType(String fsType) {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFsType = actual.getFsType();
    if (!Objects.areEqual(actualFsType, fsType)) {
      failWithMessage(assertjErrorMessage, actual, fsType, actualFsType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSource's iqn is equal to the given one.
   * @param iqn the given iqn to compare the actual ISCSIVolumeSource's iqn to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSource's iqn is not equal to the given one.
   */
  public S hasIqn(String iqn) {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting iqn of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualIqn = actual.getIqn();
    if (!Objects.areEqual(actualIqn, iqn)) {
      failWithMessage(assertjErrorMessage, actual, iqn, actualIqn);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSource's iscsiInterface is equal to the given one.
   * @param iscsiInterface the given iscsiInterface to compare the actual ISCSIVolumeSource's iscsiInterface to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSource's iscsiInterface is not equal to the given one.
   */
  public S hasIscsiInterface(String iscsiInterface) {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting iscsiInterface of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualIscsiInterface = actual.getIscsiInterface();
    if (!Objects.areEqual(actualIscsiInterface, iscsiInterface)) {
      failWithMessage(assertjErrorMessage, actual, iscsiInterface, actualIscsiInterface);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSource's lun is equal to the given one.
   * @param lun the given lun to compare the actual ISCSIVolumeSource's lun to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSource's lun is not equal to the given one.
   */
  public S hasLun(Integer lun) {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lun of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLun = actual.getLun();
    if (!Objects.areEqual(actualLun, lun)) {
      failWithMessage(assertjErrorMessage, actual, lun, actualLun);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSource's readOnly is equal to the given one.
   * @param readOnly the given readOnly to compare the actual ISCSIVolumeSource's readOnly to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSource's readOnly is not equal to the given one.
   */
  public S hasReadOnly(Boolean readOnly) {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readOnly of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualReadOnly = actual.getReadOnly();
    if (!Objects.areEqual(actualReadOnly, readOnly)) {
      failWithMessage(assertjErrorMessage, actual, readOnly, actualReadOnly);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSource's targetPortal is equal to the given one.
   * @param targetPortal the given targetPortal to compare the actual ISCSIVolumeSource's targetPortal to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSource's targetPortal is not equal to the given one.
   */
  public S hasTargetPortal(String targetPortal) {
    // check that actual ISCSIVolumeSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetPortal of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualTargetPortal = actual.getTargetPortal();
    if (!Objects.areEqual(actualTargetPortal, targetPortal)) {
      failWithMessage(assertjErrorMessage, actual, targetPortal, actualTargetPortal);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
