package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DaemonSetUpdateStrategyFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDaemonSetUpdateStrategyFluentAssert<S extends AbstractDaemonSetUpdateStrategyFluentAssert<S, A>, A extends DaemonSetUpdateStrategyFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDaemonSetUpdateStrategyFluentAssert}</code> to make assertions on actual DaemonSetUpdateStrategyFluent.
   * @param actual the DaemonSetUpdateStrategyFluent we want to make assertions on.
   */
  protected AbstractDaemonSetUpdateStrategyFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DaemonSetUpdateStrategyFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DaemonSetUpdateStrategyFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetUpdateStrategyFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DaemonSetUpdateStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetUpdateStrategyFluent's rollingUpdate is equal to the given one.
   * @param rollingUpdate the given rollingUpdate to compare the actual DaemonSetUpdateStrategyFluent's rollingUpdate to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetUpdateStrategyFluent's rollingUpdate is not equal to the given one.
   */
  public S hasRollingUpdate(RollingUpdateDaemonSet rollingUpdate) {
    // check that actual DaemonSetUpdateStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rollingUpdate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RollingUpdateDaemonSet actualRollingUpdate = actual.getRollingUpdate();
    if (!Objects.areEqual(actualRollingUpdate, rollingUpdate)) {
      failWithMessage(assertjErrorMessage, actual, rollingUpdate, actualRollingUpdate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DaemonSetUpdateStrategyFluent's type is equal to the given one.
   * @param type the given type to compare the actual DaemonSetUpdateStrategyFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DaemonSetUpdateStrategyFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual DaemonSetUpdateStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
