package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ISCSIVolumeSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractISCSIVolumeSourceFluentAssert<S extends AbstractISCSIVolumeSourceFluentAssert<S, A>, A extends ISCSIVolumeSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractISCSIVolumeSourceFluentAssert}</code> to make assertions on actual ISCSIVolumeSourceFluent.
   * @param actual the ISCSIVolumeSourceFluent we want to make assertions on.
   */
  protected AbstractISCSIVolumeSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ISCSIVolumeSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ISCSIVolumeSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ISCSIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSourceFluent's fsType is equal to the given one.
   * @param fsType the given fsType to compare the actual ISCSIVolumeSourceFluent's fsType to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSourceFluent's fsType is not equal to the given one.
   */
  public S hasFsType(String fsType) {
    // check that actual ISCSIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting fsType of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFsType = actual.getFsType();
    if (!Objects.areEqual(actualFsType, fsType)) {
      failWithMessage(assertjErrorMessage, actual, fsType, actualFsType);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSourceFluent's iqn is equal to the given one.
   * @param iqn the given iqn to compare the actual ISCSIVolumeSourceFluent's iqn to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSourceFluent's iqn is not equal to the given one.
   */
  public S hasIqn(String iqn) {
    // check that actual ISCSIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting iqn of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualIqn = actual.getIqn();
    if (!Objects.areEqual(actualIqn, iqn)) {
      failWithMessage(assertjErrorMessage, actual, iqn, actualIqn);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSourceFluent's iscsiInterface is equal to the given one.
   * @param iscsiInterface the given iscsiInterface to compare the actual ISCSIVolumeSourceFluent's iscsiInterface to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSourceFluent's iscsiInterface is not equal to the given one.
   */
  public S hasIscsiInterface(String iscsiInterface) {
    // check that actual ISCSIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting iscsiInterface of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualIscsiInterface = actual.getIscsiInterface();
    if (!Objects.areEqual(actualIscsiInterface, iscsiInterface)) {
      failWithMessage(assertjErrorMessage, actual, iscsiInterface, actualIscsiInterface);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSourceFluent's lun is equal to the given one.
   * @param lun the given lun to compare the actual ISCSIVolumeSourceFluent's lun to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSourceFluent's lun is not equal to the given one.
   */
  public S hasLun(Integer lun) {
    // check that actual ISCSIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lun of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLun = actual.getLun();
    if (!Objects.areEqual(actualLun, lun)) {
      failWithMessage(assertjErrorMessage, actual, lun, actualLun);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ISCSIVolumeSourceFluent's targetPortal is equal to the given one.
   * @param targetPortal the given targetPortal to compare the actual ISCSIVolumeSourceFluent's targetPortal to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ISCSIVolumeSourceFluent's targetPortal is not equal to the given one.
   */
  public S hasTargetPortal(String targetPortal) {
    // check that actual ISCSIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting targetPortal of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualTargetPortal = actual.getTargetPortal();
    if (!Objects.areEqual(actualTargetPortal, targetPortal)) {
      failWithMessage(assertjErrorMessage, actual, targetPortal, actualTargetPortal);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
