package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link LifecycleFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractLifecycleFluentAssert<S extends AbstractLifecycleFluentAssert<S, A>, A extends LifecycleFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractLifecycleFluentAssert}</code> to make assertions on actual LifecycleFluent.
   * @param actual the LifecycleFluent we want to make assertions on.
   */
  protected AbstractLifecycleFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual LifecycleFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual LifecycleFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual LifecycleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleFluent's postStart is equal to the given one.
   * @param postStart the given postStart to compare the actual LifecycleFluent's postStart to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleFluent's postStart is not equal to the given one.
   */
  public S hasPostStart(Handler postStart) {
    // check that actual LifecycleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting postStart of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Handler actualPostStart = actual.getPostStart();
    if (!Objects.areEqual(actualPostStart, postStart)) {
      failWithMessage(assertjErrorMessage, actual, postStart, actualPostStart);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual LifecycleFluent's preStop is equal to the given one.
   * @param preStop the given preStop to compare the actual LifecycleFluent's preStop to.
   * @return this assertion object.
   * @throws AssertionError - if the actual LifecycleFluent's preStop is not equal to the given one.
   */
  public S hasPreStop(Handler preStop) {
    // check that actual LifecycleFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting preStop of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Handler actualPreStop = actual.getPreStop();
    if (!Objects.areEqual(actualPreStop, preStop)) {
      failWithMessage(assertjErrorMessage, actual, preStop, actualPreStop);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
