package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DownwardAPIVolumeSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDownwardAPIVolumeSourceFluentAssert<S extends AbstractDownwardAPIVolumeSourceFluentAssert<S, A>, A extends DownwardAPIVolumeSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDownwardAPIVolumeSourceFluentAssert}</code> to make assertions on actual DownwardAPIVolumeSourceFluent.
   * @param actual the DownwardAPIVolumeSourceFluent we want to make assertions on.
   */
  protected AbstractDownwardAPIVolumeSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DownwardAPIVolumeSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DownwardAPIVolumeSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DownwardAPIVolumeSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DownwardAPIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DownwardAPIVolumeSourceFluent's items contains the given DownwardAPIVolumeFile elements.
   * @param items the given elements that should be contained in actual DownwardAPIVolumeSourceFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual DownwardAPIVolumeSourceFluent's items does not contain all given DownwardAPIVolumeFile elements.
   */
  public S hasItems(DownwardAPIVolumeFile... items) {
    // check that actual DownwardAPIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given DownwardAPIVolumeFile varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DownwardAPIVolumeSourceFluent's items contains <b>only<b> the given DownwardAPIVolumeFile elements and nothing else in whatever order.
   * @param items the given elements that should be contained in actual DownwardAPIVolumeSourceFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual DownwardAPIVolumeSourceFluent's items does not contain all given DownwardAPIVolumeFile elements.
   */
  public S hasOnlyItems(DownwardAPIVolumeFile... items) {
    // check that actual DownwardAPIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given DownwardAPIVolumeFile varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DownwardAPIVolumeSourceFluent's items does not contain the given DownwardAPIVolumeFile elements.
   *
   * @param items the given elements that should not be in actual DownwardAPIVolumeSourceFluent's items.
   * @return this assertion object.
   * @throws AssertionError if the actual DownwardAPIVolumeSourceFluent's items contains any given DownwardAPIVolumeFile elements.
   */
  public S doesNotHaveItems(DownwardAPIVolumeFile... items) {
    // check that actual DownwardAPIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // check that given DownwardAPIVolumeFile varargs is not null.
    if (items == null) failWithMessage("Expecting items parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getItems(), items);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DownwardAPIVolumeSourceFluent has no items.
   * @return this assertion object.
   * @throws AssertionError if the actual DownwardAPIVolumeSourceFluent's items is not empty.
   */
  public S hasNoItems() {
    // check that actual DownwardAPIVolumeSourceFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have items but had :\n  <%s>";
    
    // check
    if (actual.getItems().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getItems());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
