/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableLimitRangeItem;
import io.fabric8.kubernetes.api.model.LimitRangeItem;
import io.fabric8.kubernetes.api.model.LimitRangeItemFluent;
import io.fabric8.kubernetes.api.model.LimitRangeItemFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LimitRangeItemBuilder
extends LimitRangeItemFluentImpl<LimitRangeItemBuilder>
implements VisitableBuilder<LimitRangeItem, LimitRangeItemBuilder> {
    LimitRangeItemFluent<?> fluent;

    public LimitRangeItemBuilder() {
        this(new LimitRangeItem());
    }

    public LimitRangeItemBuilder(LimitRangeItemFluent<?> fluent) {
        this(fluent, new LimitRangeItem());
    }

    public LimitRangeItemBuilder(LimitRangeItemFluent<?> fluent, LimitRangeItem instance) {
        this.fluent = fluent;
        fluent.withDefault(instance.getDefault());
        fluent.withDefaultRequest(instance.getDefaultRequest());
        fluent.withMax(instance.getMax());
        fluent.withMaxLimitRequestRatio(instance.getMaxLimitRequestRatio());
        fluent.withMin(instance.getMin());
        fluent.withType(instance.getType());
    }

    public LimitRangeItemBuilder(LimitRangeItem instance) {
        this.fluent = this;
        this.withDefault(instance.getDefault());
        this.withDefaultRequest(instance.getDefaultRequest());
        this.withMax(instance.getMax());
        this.withMaxLimitRequestRatio(instance.getMaxLimitRequestRatio());
        this.withMin(instance.getMin());
        this.withType(instance.getType());
    }

    public EditableLimitRangeItem build() {
        EditableLimitRangeItem buildable = new EditableLimitRangeItem(this.fluent.getDefault(), this.fluent.getDefaultRequest(), this.fluent.getMax(), this.fluent.getMaxLimitRequestRatio(), this.fluent.getMin(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeItemBuilder that = (LimitRangeItemBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

