package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link KubeSchemaFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubeSchemaFluentAssert<S extends AbstractKubeSchemaFluentAssert<S, A>, A extends KubeSchemaFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubeSchemaFluentAssert}</code> to make assertions on actual KubeSchemaFluent.
   * @param actual the KubeSchemaFluent we want to make assertions on.
   */
  protected AbstractKubeSchemaFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual KubeSchemaFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual KubeSchemaFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's baseKubernetesList is equal to the given one.
   * @param baseKubernetesList the given baseKubernetesList to compare the actual KubeSchemaFluent's baseKubernetesList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's baseKubernetesList is not equal to the given one.
   */
  public S hasBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting baseKubernetesList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BaseKubernetesList actualBaseKubernetesList = actual.getBaseKubernetesList();
    if (!Objects.areEqual(actualBaseKubernetesList, baseKubernetesList)) {
      failWithMessage(assertjErrorMessage, actual, baseKubernetesList, actualBaseKubernetesList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's binding is equal to the given one.
   * @param binding the given binding to compare the actual KubeSchemaFluent's binding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's binding is not equal to the given one.
   */
  public S hasBinding(Binding binding) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting binding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Binding actualBinding = actual.getBinding();
    if (!Objects.areEqual(actualBinding, binding)) {
      failWithMessage(assertjErrorMessage, actual, binding, actualBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's buildConfigList is equal to the given one.
   * @param buildConfigList the given buildConfigList to compare the actual KubeSchemaFluent's buildConfigList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's buildConfigList is not equal to the given one.
   */
  public S hasBuildConfigList(io.fabric8.openshift.api.model.BuildConfigList buildConfigList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting buildConfigList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildConfigList actualBuildConfigList = actual.getBuildConfigList();
    if (!Objects.areEqual(actualBuildConfigList, buildConfigList)) {
      failWithMessage(assertjErrorMessage, actual, buildConfigList, actualBuildConfigList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's buildList is equal to the given one.
   * @param buildList the given buildList to compare the actual KubeSchemaFluent's buildList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's buildList is not equal to the given one.
   */
  public S hasBuildList(io.fabric8.openshift.api.model.BuildList buildList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting buildList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildList actualBuildList = actual.getBuildList();
    if (!Objects.areEqual(actualBuildList, buildList)) {
      failWithMessage(assertjErrorMessage, actual, buildList, actualBuildList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's buildRequest is equal to the given one.
   * @param buildRequest the given buildRequest to compare the actual KubeSchemaFluent's buildRequest to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's buildRequest is not equal to the given one.
   */
  public S hasBuildRequest(io.fabric8.openshift.api.model.BuildRequest buildRequest) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting buildRequest of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.BuildRequest actualBuildRequest = actual.getBuildRequest();
    if (!Objects.areEqual(actualBuildRequest, buildRequest)) {
      failWithMessage(assertjErrorMessage, actual, buildRequest, actualBuildRequest);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's clusterPolicy is equal to the given one.
   * @param clusterPolicy the given clusterPolicy to compare the actual KubeSchemaFluent's clusterPolicy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's clusterPolicy is not equal to the given one.
   */
  public S hasClusterPolicy(io.fabric8.openshift.api.model.ClusterPolicy clusterPolicy) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clusterPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterPolicy actualClusterPolicy = actual.getClusterPolicy();
    if (!Objects.areEqual(actualClusterPolicy, clusterPolicy)) {
      failWithMessage(assertjErrorMessage, actual, clusterPolicy, actualClusterPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's clusterPolicyBinding is equal to the given one.
   * @param clusterPolicyBinding the given clusterPolicyBinding to compare the actual KubeSchemaFluent's clusterPolicyBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's clusterPolicyBinding is not equal to the given one.
   */
  public S hasClusterPolicyBinding(io.fabric8.openshift.api.model.ClusterPolicyBinding clusterPolicyBinding) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clusterPolicyBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterPolicyBinding actualClusterPolicyBinding = actual.getClusterPolicyBinding();
    if (!Objects.areEqual(actualClusterPolicyBinding, clusterPolicyBinding)) {
      failWithMessage(assertjErrorMessage, actual, clusterPolicyBinding, actualClusterPolicyBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's clusterPolicyBindingList is equal to the given one.
   * @param clusterPolicyBindingList the given clusterPolicyBindingList to compare the actual KubeSchemaFluent's clusterPolicyBindingList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's clusterPolicyBindingList is not equal to the given one.
   */
  public S hasClusterPolicyBindingList(io.fabric8.openshift.api.model.ClusterPolicyBindingList clusterPolicyBindingList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clusterPolicyBindingList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterPolicyBindingList actualClusterPolicyBindingList = actual.getClusterPolicyBindingList();
    if (!Objects.areEqual(actualClusterPolicyBindingList, clusterPolicyBindingList)) {
      failWithMessage(assertjErrorMessage, actual, clusterPolicyBindingList, actualClusterPolicyBindingList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's clusterPolicyList is equal to the given one.
   * @param clusterPolicyList the given clusterPolicyList to compare the actual KubeSchemaFluent's clusterPolicyList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's clusterPolicyList is not equal to the given one.
   */
  public S hasClusterPolicyList(io.fabric8.openshift.api.model.ClusterPolicyList clusterPolicyList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clusterPolicyList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterPolicyList actualClusterPolicyList = actual.getClusterPolicyList();
    if (!Objects.areEqual(actualClusterPolicyList, clusterPolicyList)) {
      failWithMessage(assertjErrorMessage, actual, clusterPolicyList, actualClusterPolicyList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's clusterRoleBinding is equal to the given one.
   * @param clusterRoleBinding the given clusterRoleBinding to compare the actual KubeSchemaFluent's clusterRoleBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's clusterRoleBinding is not equal to the given one.
   */
  public S hasClusterRoleBinding(io.fabric8.openshift.api.model.ClusterRoleBinding clusterRoleBinding) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clusterRoleBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterRoleBinding actualClusterRoleBinding = actual.getClusterRoleBinding();
    if (!Objects.areEqual(actualClusterRoleBinding, clusterRoleBinding)) {
      failWithMessage(assertjErrorMessage, actual, clusterRoleBinding, actualClusterRoleBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's clusterRoleBindingList is equal to the given one.
   * @param clusterRoleBindingList the given clusterRoleBindingList to compare the actual KubeSchemaFluent's clusterRoleBindingList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's clusterRoleBindingList is not equal to the given one.
   */
  public S hasClusterRoleBindingList(io.fabric8.openshift.api.model.ClusterRoleBindingList clusterRoleBindingList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting clusterRoleBindingList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ClusterRoleBindingList actualClusterRoleBindingList = actual.getClusterRoleBindingList();
    if (!Objects.areEqual(actualClusterRoleBindingList, clusterRoleBindingList)) {
      failWithMessage(assertjErrorMessage, actual, clusterRoleBindingList, actualClusterRoleBindingList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's componentStatusList is equal to the given one.
   * @param componentStatusList the given componentStatusList to compare the actual KubeSchemaFluent's componentStatusList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's componentStatusList is not equal to the given one.
   */
  public S hasComponentStatusList(ComponentStatusList componentStatusList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting componentStatusList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ComponentStatusList actualComponentStatusList = actual.getComponentStatusList();
    if (!Objects.areEqual(actualComponentStatusList, componentStatusList)) {
      failWithMessage(assertjErrorMessage, actual, componentStatusList, actualComponentStatusList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's config is equal to the given one.
   * @param config the given config to compare the actual KubeSchemaFluent's config to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's config is not equal to the given one.
   */
  public S hasConfig(Config config) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting config of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Config actualConfig = actual.getConfig();
    if (!Objects.areEqual(actualConfig, config)) {
      failWithMessage(assertjErrorMessage, actual, config, actualConfig);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's containerStatus is equal to the given one.
   * @param containerStatus the given containerStatus to compare the actual KubeSchemaFluent's containerStatus to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's containerStatus is not equal to the given one.
   */
  public S hasContainerStatus(ContainerStatus containerStatus) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting containerStatus of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ContainerStatus actualContainerStatus = actual.getContainerStatus();
    if (!Objects.areEqual(actualContainerStatus, containerStatus)) {
      failWithMessage(assertjErrorMessage, actual, containerStatus, actualContainerStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's daemonSet is equal to the given one.
   * @param daemonSet the given daemonSet to compare the actual KubeSchemaFluent's daemonSet to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's daemonSet is not equal to the given one.
   */
  public S hasDaemonSet(io.fabric8.kubernetes.api.model.extensions.DaemonSet daemonSet) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting daemonSet of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.DaemonSet actualDaemonSet = actual.getDaemonSet();
    if (!Objects.areEqual(actualDaemonSet, daemonSet)) {
      failWithMessage(assertjErrorMessage, actual, daemonSet, actualDaemonSet);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's daemonSetList is equal to the given one.
   * @param daemonSetList the given daemonSetList to compare the actual KubeSchemaFluent's daemonSetList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's daemonSetList is not equal to the given one.
   */
  public S hasDaemonSetList(io.fabric8.kubernetes.api.model.extensions.DaemonSetList daemonSetList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting daemonSetList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.DaemonSetList actualDaemonSetList = actual.getDaemonSetList();
    if (!Objects.areEqual(actualDaemonSetList, daemonSetList)) {
      failWithMessage(assertjErrorMessage, actual, daemonSetList, actualDaemonSetList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's deleteOptions is equal to the given one.
   * @param deleteOptions the given deleteOptions to compare the actual KubeSchemaFluent's deleteOptions to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's deleteOptions is not equal to the given one.
   */
  public S hasDeleteOptions(DeleteOptions deleteOptions) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deleteOptions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    DeleteOptions actualDeleteOptions = actual.getDeleteOptions();
    if (!Objects.areEqual(actualDeleteOptions, deleteOptions)) {
      failWithMessage(assertjErrorMessage, actual, deleteOptions, actualDeleteOptions);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's deployment is equal to the given one.
   * @param deployment the given deployment to compare the actual KubeSchemaFluent's deployment to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's deployment is not equal to the given one.
   */
  public S hasDeployment(io.fabric8.kubernetes.api.model.extensions.Deployment deployment) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deployment of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.Deployment actualDeployment = actual.getDeployment();
    if (!Objects.areEqual(actualDeployment, deployment)) {
      failWithMessage(assertjErrorMessage, actual, deployment, actualDeployment);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's deploymentConfigList is equal to the given one.
   * @param deploymentConfigList the given deploymentConfigList to compare the actual KubeSchemaFluent's deploymentConfigList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's deploymentConfigList is not equal to the given one.
   */
  public S hasDeploymentConfigList(io.fabric8.openshift.api.model.DeploymentConfigList deploymentConfigList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deploymentConfigList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.DeploymentConfigList actualDeploymentConfigList = actual.getDeploymentConfigList();
    if (!Objects.areEqual(actualDeploymentConfigList, deploymentConfigList)) {
      failWithMessage(assertjErrorMessage, actual, deploymentConfigList, actualDeploymentConfigList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's deploymentList is equal to the given one.
   * @param deploymentList the given deploymentList to compare the actual KubeSchemaFluent's deploymentList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's deploymentList is not equal to the given one.
   */
  public S hasDeploymentList(io.fabric8.kubernetes.api.model.extensions.DeploymentList deploymentList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deploymentList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.DeploymentList actualDeploymentList = actual.getDeploymentList();
    if (!Objects.areEqual(actualDeploymentList, deploymentList)) {
      failWithMessage(assertjErrorMessage, actual, deploymentList, actualDeploymentList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's endpoints is equal to the given one.
   * @param endpoints the given endpoints to compare the actual KubeSchemaFluent's endpoints to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's endpoints is not equal to the given one.
   */
  public S hasEndpoints(Endpoints endpoints) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting endpoints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Endpoints actualEndpoints = actual.getEndpoints();
    if (!Objects.areEqual(actualEndpoints, endpoints)) {
      failWithMessage(assertjErrorMessage, actual, endpoints, actualEndpoints);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's endpointsList is equal to the given one.
   * @param endpointsList the given endpointsList to compare the actual KubeSchemaFluent's endpointsList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's endpointsList is not equal to the given one.
   */
  public S hasEndpointsList(EndpointsList endpointsList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting endpointsList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EndpointsList actualEndpointsList = actual.getEndpointsList();
    if (!Objects.areEqual(actualEndpointsList, endpointsList)) {
      failWithMessage(assertjErrorMessage, actual, endpointsList, actualEndpointsList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's envVar is equal to the given one.
   * @param envVar the given envVar to compare the actual KubeSchemaFluent's envVar to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's envVar is not equal to the given one.
   */
  public S hasEnvVar(EnvVar envVar) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting envVar of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EnvVar actualEnvVar = actual.getEnvVar();
    if (!Objects.areEqual(actualEnvVar, envVar)) {
      failWithMessage(assertjErrorMessage, actual, envVar, actualEnvVar);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's eventList is equal to the given one.
   * @param eventList the given eventList to compare the actual KubeSchemaFluent's eventList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's eventList is not equal to the given one.
   */
  public S hasEventList(EventList eventList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting eventList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    EventList actualEventList = actual.getEventList();
    if (!Objects.areEqual(actualEventList, eventList)) {
      failWithMessage(assertjErrorMessage, actual, eventList, actualEventList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's group is equal to the given one.
   * @param group the given group to compare the actual KubeSchemaFluent's group to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's group is not equal to the given one.
   */
  public S hasGroup(io.fabric8.openshift.api.model.Group group) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting group of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Group actualGroup = actual.getGroup();
    if (!Objects.areEqual(actualGroup, group)) {
      failWithMessage(assertjErrorMessage, actual, group, actualGroup);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's groupList is equal to the given one.
   * @param groupList the given groupList to compare the actual KubeSchemaFluent's groupList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's groupList is not equal to the given one.
   */
  public S hasGroupList(io.fabric8.openshift.api.model.GroupList groupList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting groupList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.GroupList actualGroupList = actual.getGroupList();
    if (!Objects.areEqual(actualGroupList, groupList)) {
      failWithMessage(assertjErrorMessage, actual, groupList, actualGroupList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's horizontalPodAutoscaler is equal to the given one.
   * @param horizontalPodAutoscaler the given horizontalPodAutoscaler to compare the actual KubeSchemaFluent's horizontalPodAutoscaler to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's horizontalPodAutoscaler is not equal to the given one.
   */
  public S hasHorizontalPodAutoscaler(io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler horizontalPodAutoscaler) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting horizontalPodAutoscaler of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler actualHorizontalPodAutoscaler = actual.getHorizontalPodAutoscaler();
    if (!Objects.areEqual(actualHorizontalPodAutoscaler, horizontalPodAutoscaler)) {
      failWithMessage(assertjErrorMessage, actual, horizontalPodAutoscaler, actualHorizontalPodAutoscaler);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's horizontalPodAutoscalerList is equal to the given one.
   * @param horizontalPodAutoscalerList the given horizontalPodAutoscalerList to compare the actual KubeSchemaFluent's horizontalPodAutoscalerList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's horizontalPodAutoscalerList is not equal to the given one.
   */
  public S hasHorizontalPodAutoscalerList(io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList horizontalPodAutoscalerList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting horizontalPodAutoscalerList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList actualHorizontalPodAutoscalerList = actual.getHorizontalPodAutoscalerList();
    if (!Objects.areEqual(actualHorizontalPodAutoscalerList, horizontalPodAutoscalerList)) {
      failWithMessage(assertjErrorMessage, actual, horizontalPodAutoscalerList, actualHorizontalPodAutoscalerList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's identity is equal to the given one.
   * @param identity the given identity to compare the actual KubeSchemaFluent's identity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's identity is not equal to the given one.
   */
  public S hasIdentity(io.fabric8.openshift.api.model.Identity identity) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting identity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Identity actualIdentity = actual.getIdentity();
    if (!Objects.areEqual(actualIdentity, identity)) {
      failWithMessage(assertjErrorMessage, actual, identity, actualIdentity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's identityList is equal to the given one.
   * @param identityList the given identityList to compare the actual KubeSchemaFluent's identityList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's identityList is not equal to the given one.
   */
  public S hasIdentityList(io.fabric8.openshift.api.model.IdentityList identityList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting identityList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.IdentityList actualIdentityList = actual.getIdentityList();
    if (!Objects.areEqual(actualIdentityList, identityList)) {
      failWithMessage(assertjErrorMessage, actual, identityList, actualIdentityList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's imageList is equal to the given one.
   * @param imageList the given imageList to compare the actual KubeSchemaFluent's imageList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's imageList is not equal to the given one.
   */
  public S hasImageList(io.fabric8.openshift.api.model.ImageList imageList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting imageList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ImageList actualImageList = actual.getImageList();
    if (!Objects.areEqual(actualImageList, imageList)) {
      failWithMessage(assertjErrorMessage, actual, imageList, actualImageList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's imageStreamList is equal to the given one.
   * @param imageStreamList the given imageStreamList to compare the actual KubeSchemaFluent's imageStreamList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's imageStreamList is not equal to the given one.
   */
  public S hasImageStreamList(io.fabric8.openshift.api.model.ImageStreamList imageStreamList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting imageStreamList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ImageStreamList actualImageStreamList = actual.getImageStreamList();
    if (!Objects.areEqual(actualImageStreamList, imageStreamList)) {
      failWithMessage(assertjErrorMessage, actual, imageStreamList, actualImageStreamList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's ingress is equal to the given one.
   * @param ingress the given ingress to compare the actual KubeSchemaFluent's ingress to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's ingress is not equal to the given one.
   */
  public S hasIngress(io.fabric8.kubernetes.api.model.extensions.Ingress ingress) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting ingress of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.Ingress actualIngress = actual.getIngress();
    if (!Objects.areEqual(actualIngress, ingress)) {
      failWithMessage(assertjErrorMessage, actual, ingress, actualIngress);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's ingressList is equal to the given one.
   * @param ingressList the given ingressList to compare the actual KubeSchemaFluent's ingressList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's ingressList is not equal to the given one.
   */
  public S hasIngressList(io.fabric8.kubernetes.api.model.extensions.IngressList ingressList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting ingressList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.IngressList actualIngressList = actual.getIngressList();
    if (!Objects.areEqual(actualIngressList, ingressList)) {
      failWithMessage(assertjErrorMessage, actual, ingressList, actualIngressList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's job is equal to the given one.
   * @param job the given job to compare the actual KubeSchemaFluent's job to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's job is not equal to the given one.
   */
  public S hasJob(io.fabric8.kubernetes.api.model.extensions.Job job) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting job of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.Job actualJob = actual.getJob();
    if (!Objects.areEqual(actualJob, job)) {
      failWithMessage(assertjErrorMessage, actual, job, actualJob);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's jobList is equal to the given one.
   * @param jobList the given jobList to compare the actual KubeSchemaFluent's jobList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's jobList is not equal to the given one.
   */
  public S hasJobList(io.fabric8.kubernetes.api.model.extensions.JobList jobList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting jobList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.JobList actualJobList = actual.getJobList();
    if (!Objects.areEqual(actualJobList, jobList)) {
      failWithMessage(assertjErrorMessage, actual, jobList, actualJobList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's limitRangeList is equal to the given one.
   * @param limitRangeList the given limitRangeList to compare the actual KubeSchemaFluent's limitRangeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's limitRangeList is not equal to the given one.
   */
  public S hasLimitRangeList(LimitRangeList limitRangeList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting limitRangeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LimitRangeList actualLimitRangeList = actual.getLimitRangeList();
    if (!Objects.areEqual(actualLimitRangeList, limitRangeList)) {
      failWithMessage(assertjErrorMessage, actual, limitRangeList, actualLimitRangeList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's listMeta is equal to the given one.
   * @param listMeta the given listMeta to compare the actual KubeSchemaFluent's listMeta to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's listMeta is not equal to the given one.
   */
  public S hasListMeta(ListMeta listMeta) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting listMeta of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ListMeta actualListMeta = actual.getListMeta();
    if (!Objects.areEqual(actualListMeta, listMeta)) {
      failWithMessage(assertjErrorMessage, actual, listMeta, actualListMeta);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's localSubjectAccessReview is equal to the given one.
   * @param localSubjectAccessReview the given localSubjectAccessReview to compare the actual KubeSchemaFluent's localSubjectAccessReview to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's localSubjectAccessReview is not equal to the given one.
   */
  public S hasLocalSubjectAccessReview(io.fabric8.openshift.api.model.LocalSubjectAccessReview localSubjectAccessReview) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting localSubjectAccessReview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.LocalSubjectAccessReview actualLocalSubjectAccessReview = actual.getLocalSubjectAccessReview();
    if (!Objects.areEqual(actualLocalSubjectAccessReview, localSubjectAccessReview)) {
      failWithMessage(assertjErrorMessage, actual, localSubjectAccessReview, actualLocalSubjectAccessReview);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's namespace is equal to the given one.
   * @param namespace the given namespace to compare the actual KubeSchemaFluent's namespace to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's namespace is not equal to the given one.
   */
  public S hasNamespace(Namespace namespace) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Namespace actualNamespace = actual.getNamespace();
    if (!Objects.areEqual(actualNamespace, namespace)) {
      failWithMessage(assertjErrorMessage, actual, namespace, actualNamespace);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's namespaceList is equal to the given one.
   * @param namespaceList the given namespaceList to compare the actual KubeSchemaFluent's namespaceList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's namespaceList is not equal to the given one.
   */
  public S hasNamespaceList(NamespaceList namespaceList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting namespaceList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NamespaceList actualNamespaceList = actual.getNamespaceList();
    if (!Objects.areEqual(actualNamespaceList, namespaceList)) {
      failWithMessage(assertjErrorMessage, actual, namespaceList, actualNamespaceList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's node is equal to the given one.
   * @param node the given node to compare the actual KubeSchemaFluent's node to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's node is not equal to the given one.
   */
  public S hasNode(Node node) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting node of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Node actualNode = actual.getNode();
    if (!Objects.areEqual(actualNode, node)) {
      failWithMessage(assertjErrorMessage, actual, node, actualNode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's nodeList is equal to the given one.
   * @param nodeList the given nodeList to compare the actual KubeSchemaFluent's nodeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's nodeList is not equal to the given one.
   */
  public S hasNodeList(NodeList nodeList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting nodeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    NodeList actualNodeList = actual.getNodeList();
    if (!Objects.areEqual(actualNodeList, nodeList)) {
      failWithMessage(assertjErrorMessage, actual, nodeList, actualNodeList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's oAuthAccessToken is equal to the given one.
   * @param oAuthAccessToken the given oAuthAccessToken to compare the actual KubeSchemaFluent's oAuthAccessToken to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's oAuthAccessToken is not equal to the given one.
   */
  public S hasOAuthAccessToken(io.fabric8.openshift.api.model.OAuthAccessToken oAuthAccessToken) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting oAuthAccessToken of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAccessToken actualOAuthAccessToken = actual.getOAuthAccessToken();
    if (!Objects.areEqual(actualOAuthAccessToken, oAuthAccessToken)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAccessToken, actualOAuthAccessToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's oAuthAccessTokenList is equal to the given one.
   * @param oAuthAccessTokenList the given oAuthAccessTokenList to compare the actual KubeSchemaFluent's oAuthAccessTokenList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's oAuthAccessTokenList is not equal to the given one.
   */
  public S hasOAuthAccessTokenList(io.fabric8.openshift.api.model.OAuthAccessTokenList oAuthAccessTokenList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting oAuthAccessTokenList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAccessTokenList actualOAuthAccessTokenList = actual.getOAuthAccessTokenList();
    if (!Objects.areEqual(actualOAuthAccessTokenList, oAuthAccessTokenList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAccessTokenList, actualOAuthAccessTokenList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's oAuthAuthorizeToken is equal to the given one.
   * @param oAuthAuthorizeToken the given oAuthAuthorizeToken to compare the actual KubeSchemaFluent's oAuthAuthorizeToken to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's oAuthAuthorizeToken is not equal to the given one.
   */
  public S hasOAuthAuthorizeToken(io.fabric8.openshift.api.model.OAuthAuthorizeToken oAuthAuthorizeToken) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting oAuthAuthorizeToken of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAuthorizeToken actualOAuthAuthorizeToken = actual.getOAuthAuthorizeToken();
    if (!Objects.areEqual(actualOAuthAuthorizeToken, oAuthAuthorizeToken)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAuthorizeToken, actualOAuthAuthorizeToken);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's oAuthAuthorizeTokenList is equal to the given one.
   * @param oAuthAuthorizeTokenList the given oAuthAuthorizeTokenList to compare the actual KubeSchemaFluent's oAuthAuthorizeTokenList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's oAuthAuthorizeTokenList is not equal to the given one.
   */
  public S hasOAuthAuthorizeTokenList(io.fabric8.openshift.api.model.OAuthAuthorizeTokenList oAuthAuthorizeTokenList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting oAuthAuthorizeTokenList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthAuthorizeTokenList actualOAuthAuthorizeTokenList = actual.getOAuthAuthorizeTokenList();
    if (!Objects.areEqual(actualOAuthAuthorizeTokenList, oAuthAuthorizeTokenList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthAuthorizeTokenList, actualOAuthAuthorizeTokenList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's oAuthClient is equal to the given one.
   * @param oAuthClient the given oAuthClient to compare the actual KubeSchemaFluent's oAuthClient to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's oAuthClient is not equal to the given one.
   */
  public S hasOAuthClient(io.fabric8.openshift.api.model.OAuthClient oAuthClient) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting oAuthClient of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClient actualOAuthClient = actual.getOAuthClient();
    if (!Objects.areEqual(actualOAuthClient, oAuthClient)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClient, actualOAuthClient);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's oAuthClientAuthorization is equal to the given one.
   * @param oAuthClientAuthorization the given oAuthClientAuthorization to compare the actual KubeSchemaFluent's oAuthClientAuthorization to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's oAuthClientAuthorization is not equal to the given one.
   */
  public S hasOAuthClientAuthorization(io.fabric8.openshift.api.model.OAuthClientAuthorization oAuthClientAuthorization) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting oAuthClientAuthorization of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientAuthorization actualOAuthClientAuthorization = actual.getOAuthClientAuthorization();
    if (!Objects.areEqual(actualOAuthClientAuthorization, oAuthClientAuthorization)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientAuthorization, actualOAuthClientAuthorization);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's oAuthClientAuthorizationList is equal to the given one.
   * @param oAuthClientAuthorizationList the given oAuthClientAuthorizationList to compare the actual KubeSchemaFluent's oAuthClientAuthorizationList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's oAuthClientAuthorizationList is not equal to the given one.
   */
  public S hasOAuthClientAuthorizationList(io.fabric8.openshift.api.model.OAuthClientAuthorizationList oAuthClientAuthorizationList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting oAuthClientAuthorizationList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientAuthorizationList actualOAuthClientAuthorizationList = actual.getOAuthClientAuthorizationList();
    if (!Objects.areEqual(actualOAuthClientAuthorizationList, oAuthClientAuthorizationList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientAuthorizationList, actualOAuthClientAuthorizationList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's oAuthClientList is equal to the given one.
   * @param oAuthClientList the given oAuthClientList to compare the actual KubeSchemaFluent's oAuthClientList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's oAuthClientList is not equal to the given one.
   */
  public S hasOAuthClientList(io.fabric8.openshift.api.model.OAuthClientList oAuthClientList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting oAuthClientList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.OAuthClientList actualOAuthClientList = actual.getOAuthClientList();
    if (!Objects.areEqual(actualOAuthClientList, oAuthClientList)) {
      failWithMessage(assertjErrorMessage, actual, oAuthClientList, actualOAuthClientList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's objectMeta is equal to the given one.
   * @param objectMeta the given objectMeta to compare the actual KubeSchemaFluent's objectMeta to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's objectMeta is not equal to the given one.
   */
  public S hasObjectMeta(ObjectMeta objectMeta) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting objectMeta of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ObjectMeta actualObjectMeta = actual.getObjectMeta();
    if (!Objects.areEqual(actualObjectMeta, objectMeta)) {
      failWithMessage(assertjErrorMessage, actual, objectMeta, actualObjectMeta);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's persistentVolume is equal to the given one.
   * @param persistentVolume the given persistentVolume to compare the actual KubeSchemaFluent's persistentVolume to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's persistentVolume is not equal to the given one.
   */
  public S hasPersistentVolume(PersistentVolume persistentVolume) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting persistentVolume of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolume actualPersistentVolume = actual.getPersistentVolume();
    if (!Objects.areEqual(actualPersistentVolume, persistentVolume)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolume, actualPersistentVolume);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's persistentVolumeClaim is equal to the given one.
   * @param persistentVolumeClaim the given persistentVolumeClaim to compare the actual KubeSchemaFluent's persistentVolumeClaim to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's persistentVolumeClaim is not equal to the given one.
   */
  public S hasPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting persistentVolumeClaim of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaim actualPersistentVolumeClaim = actual.getPersistentVolumeClaim();
    if (!Objects.areEqual(actualPersistentVolumeClaim, persistentVolumeClaim)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeClaim, actualPersistentVolumeClaim);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's persistentVolumeClaimList is equal to the given one.
   * @param persistentVolumeClaimList the given persistentVolumeClaimList to compare the actual KubeSchemaFluent's persistentVolumeClaimList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's persistentVolumeClaimList is not equal to the given one.
   */
  public S hasPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting persistentVolumeClaimList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeClaimList actualPersistentVolumeClaimList = actual.getPersistentVolumeClaimList();
    if (!Objects.areEqual(actualPersistentVolumeClaimList, persistentVolumeClaimList)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeClaimList, actualPersistentVolumeClaimList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's persistentVolumeList is equal to the given one.
   * @param persistentVolumeList the given persistentVolumeList to compare the actual KubeSchemaFluent's persistentVolumeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's persistentVolumeList is not equal to the given one.
   */
  public S hasPersistentVolumeList(PersistentVolumeList persistentVolumeList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting persistentVolumeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PersistentVolumeList actualPersistentVolumeList = actual.getPersistentVolumeList();
    if (!Objects.areEqual(actualPersistentVolumeList, persistentVolumeList)) {
      failWithMessage(assertjErrorMessage, actual, persistentVolumeList, actualPersistentVolumeList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's podList is equal to the given one.
   * @param podList the given podList to compare the actual KubeSchemaFluent's podList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's podList is not equal to the given one.
   */
  public S hasPodList(PodList podList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting podList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodList actualPodList = actual.getPodList();
    if (!Objects.areEqual(actualPodList, podList)) {
      failWithMessage(assertjErrorMessage, actual, podList, actualPodList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's podTemplateList is equal to the given one.
   * @param podTemplateList the given podTemplateList to compare the actual KubeSchemaFluent's podTemplateList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's podTemplateList is not equal to the given one.
   */
  public S hasPodTemplateList(PodTemplateList podTemplateList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting podTemplateList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    PodTemplateList actualPodTemplateList = actual.getPodTemplateList();
    if (!Objects.areEqual(actualPodTemplateList, podTemplateList)) {
      failWithMessage(assertjErrorMessage, actual, podTemplateList, actualPodTemplateList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's policy is equal to the given one.
   * @param policy the given policy to compare the actual KubeSchemaFluent's policy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's policy is not equal to the given one.
   */
  public S hasPolicy(io.fabric8.openshift.api.model.Policy policy) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting policy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Policy actualPolicy = actual.getPolicy();
    if (!Objects.areEqual(actualPolicy, policy)) {
      failWithMessage(assertjErrorMessage, actual, policy, actualPolicy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's policyBinding is equal to the given one.
   * @param policyBinding the given policyBinding to compare the actual KubeSchemaFluent's policyBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's policyBinding is not equal to the given one.
   */
  public S hasPolicyBinding(io.fabric8.openshift.api.model.PolicyBinding policyBinding) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting policyBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.PolicyBinding actualPolicyBinding = actual.getPolicyBinding();
    if (!Objects.areEqual(actualPolicyBinding, policyBinding)) {
      failWithMessage(assertjErrorMessage, actual, policyBinding, actualPolicyBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's policyBindingList is equal to the given one.
   * @param policyBindingList the given policyBindingList to compare the actual KubeSchemaFluent's policyBindingList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's policyBindingList is not equal to the given one.
   */
  public S hasPolicyBindingList(io.fabric8.openshift.api.model.PolicyBindingList policyBindingList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting policyBindingList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.PolicyBindingList actualPolicyBindingList = actual.getPolicyBindingList();
    if (!Objects.areEqual(actualPolicyBindingList, policyBindingList)) {
      failWithMessage(assertjErrorMessage, actual, policyBindingList, actualPolicyBindingList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's policyList is equal to the given one.
   * @param policyList the given policyList to compare the actual KubeSchemaFluent's policyList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's policyList is not equal to the given one.
   */
  public S hasPolicyList(io.fabric8.openshift.api.model.PolicyList policyList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting policyList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.PolicyList actualPolicyList = actual.getPolicyList();
    if (!Objects.areEqual(actualPolicyList, policyList)) {
      failWithMessage(assertjErrorMessage, actual, policyList, actualPolicyList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's project is equal to the given one.
   * @param project the given project to compare the actual KubeSchemaFluent's project to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's project is not equal to the given one.
   */
  public S hasProject(io.fabric8.openshift.api.model.Project project) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting project of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Project actualProject = actual.getProject();
    if (!Objects.areEqual(actualProject, project)) {
      failWithMessage(assertjErrorMessage, actual, project, actualProject);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's projectList is equal to the given one.
   * @param projectList the given projectList to compare the actual KubeSchemaFluent's projectList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's projectList is not equal to the given one.
   */
  public S hasProjectList(io.fabric8.openshift.api.model.ProjectList projectList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting projectList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ProjectList actualProjectList = actual.getProjectList();
    if (!Objects.areEqual(actualProjectList, projectList)) {
      failWithMessage(assertjErrorMessage, actual, projectList, actualProjectList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's projectRequest is equal to the given one.
   * @param projectRequest the given projectRequest to compare the actual KubeSchemaFluent's projectRequest to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's projectRequest is not equal to the given one.
   */
  public S hasProjectRequest(io.fabric8.openshift.api.model.ProjectRequest projectRequest) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting projectRequest of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.ProjectRequest actualProjectRequest = actual.getProjectRequest();
    if (!Objects.areEqual(actualProjectRequest, projectRequest)) {
      failWithMessage(assertjErrorMessage, actual, projectRequest, actualProjectRequest);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's quantity is equal to the given one.
   * @param quantity the given quantity to compare the actual KubeSchemaFluent's quantity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's quantity is not equal to the given one.
   */
  public S hasQuantity(Quantity quantity) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting quantity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Quantity actualQuantity = actual.getQuantity();
    if (!Objects.areEqual(actualQuantity, quantity)) {
      failWithMessage(assertjErrorMessage, actual, quantity, actualQuantity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's replicationControllerList is equal to the given one.
   * @param replicationControllerList the given replicationControllerList to compare the actual KubeSchemaFluent's replicationControllerList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's replicationControllerList is not equal to the given one.
   */
  public S hasReplicationControllerList(ReplicationControllerList replicationControllerList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicationControllerList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ReplicationControllerList actualReplicationControllerList = actual.getReplicationControllerList();
    if (!Objects.areEqual(actualReplicationControllerList, replicationControllerList)) {
      failWithMessage(assertjErrorMessage, actual, replicationControllerList, actualReplicationControllerList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's resourceQuota is equal to the given one.
   * @param resourceQuota the given resourceQuota to compare the actual KubeSchemaFluent's resourceQuota to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's resourceQuota is not equal to the given one.
   */
  public S hasResourceQuota(ResourceQuota resourceQuota) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceQuota of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ResourceQuota actualResourceQuota = actual.getResourceQuota();
    if (!Objects.areEqual(actualResourceQuota, resourceQuota)) {
      failWithMessage(assertjErrorMessage, actual, resourceQuota, actualResourceQuota);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's resourceQuotaList is equal to the given one.
   * @param resourceQuotaList the given resourceQuotaList to compare the actual KubeSchemaFluent's resourceQuotaList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's resourceQuotaList is not equal to the given one.
   */
  public S hasResourceQuotaList(ResourceQuotaList resourceQuotaList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resourceQuotaList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ResourceQuotaList actualResourceQuotaList = actual.getResourceQuotaList();
    if (!Objects.areEqual(actualResourceQuotaList, resourceQuotaList)) {
      failWithMessage(assertjErrorMessage, actual, resourceQuotaList, actualResourceQuotaList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's role is equal to the given one.
   * @param role the given role to compare the actual KubeSchemaFluent's role to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's role is not equal to the given one.
   */
  public S hasRole(io.fabric8.openshift.api.model.Role role) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting role of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Role actualRole = actual.getRole();
    if (!Objects.areEqual(actualRole, role)) {
      failWithMessage(assertjErrorMessage, actual, role, actualRole);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's roleBinding is equal to the given one.
   * @param roleBinding the given roleBinding to compare the actual KubeSchemaFluent's roleBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's roleBinding is not equal to the given one.
   */
  public S hasRoleBinding(io.fabric8.openshift.api.model.RoleBinding roleBinding) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting roleBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RoleBinding actualRoleBinding = actual.getRoleBinding();
    if (!Objects.areEqual(actualRoleBinding, roleBinding)) {
      failWithMessage(assertjErrorMessage, actual, roleBinding, actualRoleBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's roleBindingList is equal to the given one.
   * @param roleBindingList the given roleBindingList to compare the actual KubeSchemaFluent's roleBindingList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's roleBindingList is not equal to the given one.
   */
  public S hasRoleBindingList(io.fabric8.openshift.api.model.RoleBindingList roleBindingList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting roleBindingList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RoleBindingList actualRoleBindingList = actual.getRoleBindingList();
    if (!Objects.areEqual(actualRoleBindingList, roleBindingList)) {
      failWithMessage(assertjErrorMessage, actual, roleBindingList, actualRoleBindingList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's roleList is equal to the given one.
   * @param roleList the given roleList to compare the actual KubeSchemaFluent's roleList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's roleList is not equal to the given one.
   */
  public S hasRoleList(io.fabric8.openshift.api.model.RoleList roleList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting roleList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RoleList actualRoleList = actual.getRoleList();
    if (!Objects.areEqual(actualRoleList, roleList)) {
      failWithMessage(assertjErrorMessage, actual, roleList, actualRoleList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's rootPaths is equal to the given one.
   * @param rootPaths the given rootPaths to compare the actual KubeSchemaFluent's rootPaths to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's rootPaths is not equal to the given one.
   */
  public S hasRootPaths(RootPaths rootPaths) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rootPaths of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RootPaths actualRootPaths = actual.getRootPaths();
    if (!Objects.areEqual(actualRootPaths, rootPaths)) {
      failWithMessage(assertjErrorMessage, actual, rootPaths, actualRootPaths);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's routeList is equal to the given one.
   * @param routeList the given routeList to compare the actual KubeSchemaFluent's routeList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's routeList is not equal to the given one.
   */
  public S hasRouteList(io.fabric8.openshift.api.model.RouteList routeList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting routeList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.RouteList actualRouteList = actual.getRouteList();
    if (!Objects.areEqual(actualRouteList, routeList)) {
      failWithMessage(assertjErrorMessage, actual, routeList, actualRouteList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's scale is equal to the given one.
   * @param scale the given scale to compare the actual KubeSchemaFluent's scale to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's scale is not equal to the given one.
   */
  public S hasScale(io.fabric8.kubernetes.api.model.extensions.Scale scale) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting scale of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.Scale actualScale = actual.getScale();
    if (!Objects.areEqual(actualScale, scale)) {
      failWithMessage(assertjErrorMessage, actual, scale, actualScale);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's secret is equal to the given one.
   * @param secret the given secret to compare the actual KubeSchemaFluent's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's secret is not equal to the given one.
   */
  public S hasSecret(Secret secret) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Secret actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's secretList is equal to the given one.
   * @param secretList the given secretList to compare the actual KubeSchemaFluent's secretList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's secretList is not equal to the given one.
   */
  public S hasSecretList(SecretList secretList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting secretList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecretList actualSecretList = actual.getSecretList();
    if (!Objects.areEqual(actualSecretList, secretList)) {
      failWithMessage(assertjErrorMessage, actual, secretList, actualSecretList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's securityContextConstraints is equal to the given one.
   * @param securityContextConstraints the given securityContextConstraints to compare the actual KubeSchemaFluent's securityContextConstraints to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's securityContextConstraints is not equal to the given one.
   */
  public S hasSecurityContextConstraints(SecurityContextConstraints securityContextConstraints) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting securityContextConstraints of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecurityContextConstraints actualSecurityContextConstraints = actual.getSecurityContextConstraints();
    if (!Objects.areEqual(actualSecurityContextConstraints, securityContextConstraints)) {
      failWithMessage(assertjErrorMessage, actual, securityContextConstraints, actualSecurityContextConstraints);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's securityContextConstraintsList is equal to the given one.
   * @param securityContextConstraintsList the given securityContextConstraintsList to compare the actual KubeSchemaFluent's securityContextConstraintsList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's securityContextConstraintsList is not equal to the given one.
   */
  public S hasSecurityContextConstraintsList(SecurityContextConstraintsList securityContextConstraintsList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting securityContextConstraintsList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SecurityContextConstraintsList actualSecurityContextConstraintsList = actual.getSecurityContextConstraintsList();
    if (!Objects.areEqual(actualSecurityContextConstraintsList, securityContextConstraintsList)) {
      failWithMessage(assertjErrorMessage, actual, securityContextConstraintsList, actualSecurityContextConstraintsList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's serviceAccount is equal to the given one.
   * @param serviceAccount the given serviceAccount to compare the actual KubeSchemaFluent's serviceAccount to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's serviceAccount is not equal to the given one.
   */
  public S hasServiceAccount(ServiceAccount serviceAccount) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting serviceAccount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceAccount actualServiceAccount = actual.getServiceAccount();
    if (!Objects.areEqual(actualServiceAccount, serviceAccount)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccount, actualServiceAccount);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's serviceAccountList is equal to the given one.
   * @param serviceAccountList the given serviceAccountList to compare the actual KubeSchemaFluent's serviceAccountList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's serviceAccountList is not equal to the given one.
   */
  public S hasServiceAccountList(ServiceAccountList serviceAccountList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting serviceAccountList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceAccountList actualServiceAccountList = actual.getServiceAccountList();
    if (!Objects.areEqual(actualServiceAccountList, serviceAccountList)) {
      failWithMessage(assertjErrorMessage, actual, serviceAccountList, actualServiceAccountList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's serviceList is equal to the given one.
   * @param serviceList the given serviceList to compare the actual KubeSchemaFluent's serviceList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's serviceList is not equal to the given one.
   */
  public S hasServiceList(ServiceList serviceList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting serviceList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ServiceList actualServiceList = actual.getServiceList();
    if (!Objects.areEqual(actualServiceList, serviceList)) {
      failWithMessage(assertjErrorMessage, actual, serviceList, actualServiceList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's status is equal to the given one.
   * @param status the given status to compare the actual KubeSchemaFluent's status to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's status is not equal to the given one.
   */
  public S hasStatus(Status status) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Status actualStatus = actual.getStatus();
    if (!Objects.areEqual(actualStatus, status)) {
      failWithMessage(assertjErrorMessage, actual, status, actualStatus);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's subjectAccessReview is equal to the given one.
   * @param subjectAccessReview the given subjectAccessReview to compare the actual KubeSchemaFluent's subjectAccessReview to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's subjectAccessReview is not equal to the given one.
   */
  public S hasSubjectAccessReview(io.fabric8.openshift.api.model.SubjectAccessReview subjectAccessReview) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting subjectAccessReview of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.SubjectAccessReview actualSubjectAccessReview = actual.getSubjectAccessReview();
    if (!Objects.areEqual(actualSubjectAccessReview, subjectAccessReview)) {
      failWithMessage(assertjErrorMessage, actual, subjectAccessReview, actualSubjectAccessReview);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's subjectAccessReviewResponse is equal to the given one.
   * @param subjectAccessReviewResponse the given subjectAccessReviewResponse to compare the actual KubeSchemaFluent's subjectAccessReviewResponse to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's subjectAccessReviewResponse is not equal to the given one.
   */
  public S hasSubjectAccessReviewResponse(io.fabric8.openshift.api.model.SubjectAccessReviewResponse subjectAccessReviewResponse) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting subjectAccessReviewResponse of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.SubjectAccessReviewResponse actualSubjectAccessReviewResponse = actual.getSubjectAccessReviewResponse();
    if (!Objects.areEqual(actualSubjectAccessReviewResponse, subjectAccessReviewResponse)) {
      failWithMessage(assertjErrorMessage, actual, subjectAccessReviewResponse, actualSubjectAccessReviewResponse);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's tagEvent is equal to the given one.
   * @param tagEvent the given tagEvent to compare the actual KubeSchemaFluent's tagEvent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's tagEvent is not equal to the given one.
   */
  public S hasTagEvent(io.fabric8.openshift.api.model.TagEvent tagEvent) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting tagEvent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.TagEvent actualTagEvent = actual.getTagEvent();
    if (!Objects.areEqual(actualTagEvent, tagEvent)) {
      failWithMessage(assertjErrorMessage, actual, tagEvent, actualTagEvent);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's template is equal to the given one.
   * @param template the given template to compare the actual KubeSchemaFluent's template to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's template is not equal to the given one.
   */
  public S hasTemplate(io.fabric8.openshift.api.model.Template template) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting template of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.Template actualTemplate = actual.getTemplate();
    if (!Objects.areEqual(actualTemplate, template)) {
      failWithMessage(assertjErrorMessage, actual, template, actualTemplate);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's templateList is equal to the given one.
   * @param templateList the given templateList to compare the actual KubeSchemaFluent's templateList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's templateList is not equal to the given one.
   */
  public S hasTemplateList(io.fabric8.openshift.api.model.TemplateList templateList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting templateList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.TemplateList actualTemplateList = actual.getTemplateList();
    if (!Objects.areEqual(actualTemplateList, templateList)) {
      failWithMessage(assertjErrorMessage, actual, templateList, actualTemplateList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's thirdPartyResource is equal to the given one.
   * @param thirdPartyResource the given thirdPartyResource to compare the actual KubeSchemaFluent's thirdPartyResource to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's thirdPartyResource is not equal to the given one.
   */
  public S hasThirdPartyResource(io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource thirdPartyResource) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting thirdPartyResource of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource actualThirdPartyResource = actual.getThirdPartyResource();
    if (!Objects.areEqual(actualThirdPartyResource, thirdPartyResource)) {
      failWithMessage(assertjErrorMessage, actual, thirdPartyResource, actualThirdPartyResource);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's thirdPartyResourceList is equal to the given one.
   * @param thirdPartyResourceList the given thirdPartyResourceList to compare the actual KubeSchemaFluent's thirdPartyResourceList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's thirdPartyResourceList is not equal to the given one.
   */
  public S hasThirdPartyResourceList(io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList thirdPartyResourceList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting thirdPartyResourceList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList actualThirdPartyResourceList = actual.getThirdPartyResourceList();
    if (!Objects.areEqual(actualThirdPartyResourceList, thirdPartyResourceList)) {
      failWithMessage(assertjErrorMessage, actual, thirdPartyResourceList, actualThirdPartyResourceList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's user is equal to the given one.
   * @param user the given user to compare the actual KubeSchemaFluent's user to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's user is not equal to the given one.
   */
  public S hasUser(io.fabric8.openshift.api.model.User user) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting user of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.User actualUser = actual.getUser();
    if (!Objects.areEqual(actualUser, user)) {
      failWithMessage(assertjErrorMessage, actual, user, actualUser);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's userList is equal to the given one.
   * @param userList the given userList to compare the actual KubeSchemaFluent's userList to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's userList is not equal to the given one.
   */
  public S hasUserList(io.fabric8.openshift.api.model.UserList userList) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting userList of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.openshift.api.model.UserList actualUserList = actual.getUserList();
    if (!Objects.areEqual(actualUserList, userList)) {
      failWithMessage(assertjErrorMessage, actual, userList, actualUserList);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual KubeSchemaFluent's watchEvent is equal to the given one.
   * @param watchEvent the given watchEvent to compare the actual KubeSchemaFluent's watchEvent to.
   * @return this assertion object.
   * @throws AssertionError - if the actual KubeSchemaFluent's watchEvent is not equal to the given one.
   */
  public S hasWatchEvent(WatchEvent watchEvent) {
    // check that actual KubeSchemaFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting watchEvent of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    WatchEvent actualWatchEvent = actual.getWatchEvent();
    if (!Objects.areEqual(actualWatchEvent, watchEvent)) {
      failWithMessage(assertjErrorMessage, actual, watchEvent, actualWatchEvent);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
