package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentTriggerImageChangeParamsFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentTriggerImageChangeParamsFluentImplAssert<S extends AbstractDeploymentTriggerImageChangeParamsFluentImplAssert<S, A>, A extends DeploymentTriggerImageChangeParamsFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentTriggerImageChangeParamsFluentImplAssert}</code> to make assertions on actual DeploymentTriggerImageChangeParamsFluentImpl.
   * @param actual the DeploymentTriggerImageChangeParamsFluentImpl we want to make assertions on.
   */
  protected AbstractDeploymentTriggerImageChangeParamsFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentTriggerImageChangeParamsFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentTriggerImageChangeParamsFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentTriggerImageChangeParamsFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentTriggerImageChangeParamsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames contains the given String elements.
   * @param containerNames the given elements that should be contained in actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames does not contain all given String elements.
   */
  public S hasContainerNames(String... containerNames) {
    // check that actual DeploymentTriggerImageChangeParamsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (containerNames == null) failWithMessage("Expecting containerNames parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getContainerNames(), containerNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param containerNames the given elements that should be contained in actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames does not contain all given String elements.
   */
  public S hasOnlyContainerNames(String... containerNames) {
    // check that actual DeploymentTriggerImageChangeParamsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (containerNames == null) failWithMessage("Expecting containerNames parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getContainerNames(), containerNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames does not contain the given String elements.
   *
   * @param containerNames the given elements that should not be in actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames contains any given String elements.
   */
  public S doesNotHaveContainerNames(String... containerNames) {
    // check that actual DeploymentTriggerImageChangeParamsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (containerNames == null) failWithMessage("Expecting containerNames parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getContainerNames(), containerNames);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentTriggerImageChangeParamsFluentImpl has no containerNames.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentTriggerImageChangeParamsFluentImpl's containerNames is not empty.
   */
  public S hasNoContainerNames() {
    // check that actual DeploymentTriggerImageChangeParamsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have containerNames but had :\n  <%s>";
    
    // check
    if (actual.getContainerNames().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getContainerNames());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual DeploymentTriggerImageChangeParamsFluentImpl's from is equal to the given one.
   * @param from the given from to compare the actual DeploymentTriggerImageChangeParamsFluentImpl's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentTriggerImageChangeParamsFluentImpl's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual DeploymentTriggerImageChangeParamsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentTriggerImageChangeParamsFluentImpl's lastTriggeredImage is equal to the given one.
   * @param lastTriggeredImage the given lastTriggeredImage to compare the actual DeploymentTriggerImageChangeParamsFluentImpl's lastTriggeredImage to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentTriggerImageChangeParamsFluentImpl's lastTriggeredImage is not equal to the given one.
   */
  public S hasLastTriggeredImage(String lastTriggeredImage) {
    // check that actual DeploymentTriggerImageChangeParamsFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastTriggeredImage of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualLastTriggeredImage = actual.getLastTriggeredImage();
    if (!Objects.areEqual(actualLastTriggeredImage, lastTriggeredImage)) {
      failWithMessage(assertjErrorMessage, actual, lastTriggeredImage, actualLastTriggeredImage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
