package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ContainerStateTerminatedFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractContainerStateTerminatedFluentImplAssert<S extends AbstractContainerStateTerminatedFluentImplAssert<S, A>, A extends ContainerStateTerminatedFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractContainerStateTerminatedFluentImplAssert}</code> to make assertions on actual ContainerStateTerminatedFluentImpl.
   * @param actual the ContainerStateTerminatedFluentImpl we want to make assertions on.
   */
  protected AbstractContainerStateTerminatedFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ContainerStateTerminatedFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ContainerStateTerminatedFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminatedFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ContainerStateTerminatedFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateTerminatedFluentImpl's containerID is equal to the given one.
   * @param containerID the given containerID to compare the actual ContainerStateTerminatedFluentImpl's containerID to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminatedFluentImpl's containerID is not equal to the given one.
   */
  public S hasContainerID(String containerID) {
    // check that actual ContainerStateTerminatedFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting containerID of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContainerID = actual.getContainerID();
    if (!Objects.areEqual(actualContainerID, containerID)) {
      failWithMessage(assertjErrorMessage, actual, containerID, actualContainerID);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateTerminatedFluentImpl's exitCode is equal to the given one.
   * @param exitCode the given exitCode to compare the actual ContainerStateTerminatedFluentImpl's exitCode to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminatedFluentImpl's exitCode is not equal to the given one.
   */
  public S hasExitCode(Integer exitCode) {
    // check that actual ContainerStateTerminatedFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting exitCode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualExitCode = actual.getExitCode();
    if (!Objects.areEqual(actualExitCode, exitCode)) {
      failWithMessage(assertjErrorMessage, actual, exitCode, actualExitCode);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateTerminatedFluentImpl's finishedAt is equal to the given one.
   * @param finishedAt the given finishedAt to compare the actual ContainerStateTerminatedFluentImpl's finishedAt to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminatedFluentImpl's finishedAt is not equal to the given one.
   */
  public S hasFinishedAt(String finishedAt) {
    // check that actual ContainerStateTerminatedFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting finishedAt of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualFinishedAt = actual.getFinishedAt();
    if (!Objects.areEqual(actualFinishedAt, finishedAt)) {
      failWithMessage(assertjErrorMessage, actual, finishedAt, actualFinishedAt);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateTerminatedFluentImpl's message is equal to the given one.
   * @param message the given message to compare the actual ContainerStateTerminatedFluentImpl's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminatedFluentImpl's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual ContainerStateTerminatedFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateTerminatedFluentImpl's reason is equal to the given one.
   * @param reason the given reason to compare the actual ContainerStateTerminatedFluentImpl's reason to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminatedFluentImpl's reason is not equal to the given one.
   */
  public S hasReason(String reason) {
    // check that actual ContainerStateTerminatedFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting reason of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualReason = actual.getReason();
    if (!Objects.areEqual(actualReason, reason)) {
      failWithMessage(assertjErrorMessage, actual, reason, actualReason);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateTerminatedFluentImpl's signal is equal to the given one.
   * @param signal the given signal to compare the actual ContainerStateTerminatedFluentImpl's signal to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminatedFluentImpl's signal is not equal to the given one.
   */
  public S hasSignal(Integer signal) {
    // check that actual ContainerStateTerminatedFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting signal of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualSignal = actual.getSignal();
    if (!Objects.areEqual(actualSignal, signal)) {
      failWithMessage(assertjErrorMessage, actual, signal, actualSignal);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ContainerStateTerminatedFluentImpl's startedAt is equal to the given one.
   * @param startedAt the given startedAt to compare the actual ContainerStateTerminatedFluentImpl's startedAt to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ContainerStateTerminatedFluentImpl's startedAt is not equal to the given one.
   */
  public S hasStartedAt(String startedAt) {
    // check that actual ContainerStateTerminatedFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting startedAt of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStartedAt = actual.getStartedAt();
    if (!Objects.areEqual(actualStartedAt, startedAt)) {
      failWithMessage(assertjErrorMessage, actual, startedAt, actualStartedAt);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
