package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SourceRevisionFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSourceRevisionFluentImplAssert<S extends AbstractSourceRevisionFluentImplAssert<S, A>, A extends SourceRevisionFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSourceRevisionFluentImplAssert}</code> to make assertions on actual SourceRevisionFluentImpl.
   * @param actual the SourceRevisionFluentImpl we want to make assertions on.
   */
  protected AbstractSourceRevisionFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SourceRevisionFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SourceRevisionFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceRevisionFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SourceRevisionFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceRevisionFluentImpl's git is equal to the given one.
   * @param git the given git to compare the actual SourceRevisionFluentImpl's git to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceRevisionFluentImpl's git is not equal to the given one.
   */
  public S hasGit(GitSourceRevision git) {
    // check that actual SourceRevisionFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting git of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitSourceRevision actualGit = actual.getGit();
    if (!Objects.areEqual(actualGit, git)) {
      failWithMessage(assertjErrorMessage, actual, git, actualGit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceRevisionFluentImpl's type is equal to the given one.
   * @param type the given type to compare the actual SourceRevisionFluentImpl's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceRevisionFluentImpl's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual SourceRevisionFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
