package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link SourceControlUser} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSourceControlUserAssert<S extends AbstractSourceControlUserAssert<S, A>, A extends SourceControlUser> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSourceControlUserAssert}</code> to make assertions on actual SourceControlUser.
   * @param actual the SourceControlUser we want to make assertions on.
   */
  protected AbstractSourceControlUserAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual SourceControlUser's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual SourceControlUser's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUser's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual SourceControlUser we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceControlUser's email is equal to the given one.
   * @param email the given email to compare the actual SourceControlUser's email to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUser's email is not equal to the given one.
   */
  public S hasEmail(String email) {
    // check that actual SourceControlUser we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting email of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualEmail = actual.getEmail();
    if (!Objects.areEqual(actualEmail, email)) {
      failWithMessage(assertjErrorMessage, actual, email, actualEmail);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual SourceControlUser's name is equal to the given one.
   * @param name the given name to compare the actual SourceControlUser's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual SourceControlUser's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual SourceControlUser we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
