package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RecreateDeploymentStrategyParams} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRecreateDeploymentStrategyParamsAssert<S extends AbstractRecreateDeploymentStrategyParamsAssert<S, A>, A extends RecreateDeploymentStrategyParams> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRecreateDeploymentStrategyParamsAssert}</code> to make assertions on actual RecreateDeploymentStrategyParams.
   * @param actual the RecreateDeploymentStrategyParams we want to make assertions on.
   */
  protected AbstractRecreateDeploymentStrategyParamsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RecreateDeploymentStrategyParams's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RecreateDeploymentStrategyParams's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecreateDeploymentStrategyParams's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RecreateDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RecreateDeploymentStrategyParams's post is equal to the given one.
   * @param post the given post to compare the actual RecreateDeploymentStrategyParams's post to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecreateDeploymentStrategyParams's post is not equal to the given one.
   */
  public S hasPost(LifecycleHook post) {
    // check that actual RecreateDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting post of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LifecycleHook actualPost = actual.getPost();
    if (!Objects.areEqual(actualPost, post)) {
      failWithMessage(assertjErrorMessage, actual, post, actualPost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RecreateDeploymentStrategyParams's pre is equal to the given one.
   * @param pre the given pre to compare the actual RecreateDeploymentStrategyParams's pre to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecreateDeploymentStrategyParams's pre is not equal to the given one.
   */
  public S hasPre(LifecycleHook pre) {
    // check that actual RecreateDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting pre of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    LifecycleHook actualPre = actual.getPre();
    if (!Objects.areEqual(actualPre, pre)) {
      failWithMessage(assertjErrorMessage, actual, pre, actualPre);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
