package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentDetails} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentDetailsAssert<S extends AbstractDeploymentDetailsAssert<S, A>, A extends DeploymentDetails> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentDetailsAssert}</code> to make assertions on actual DeploymentDetails.
   * @param actual the DeploymentDetails we want to make assertions on.
   */
  protected AbstractDeploymentDetailsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentDetails's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentDetails's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentDetails's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentDetails we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentDetails's causes contains the given DeploymentCause elements.
   * @param causes the given elements that should be contained in actual DeploymentDetails's causes.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentDetails's causes does not contain all given DeploymentCause elements.
   */
  public S hasCauses(DeploymentCause... causes) {
    // check that actual DeploymentDetails we want to make assertions on is not null.
    isNotNull();

    // check that given DeploymentCause varargs is not null.
    if (causes == null) failWithMessage("Expecting causes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getCauses(), causes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentDetails's causes contains <b>only<b> the given DeploymentCause elements and nothing else in whatever order.
   * @param causes the given elements that should be contained in actual DeploymentDetails's causes.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentDetails's causes does not contain all given DeploymentCause elements.
   */
  public S hasOnlyCauses(DeploymentCause... causes) {
    // check that actual DeploymentDetails we want to make assertions on is not null.
    isNotNull();

    // check that given DeploymentCause varargs is not null.
    if (causes == null) failWithMessage("Expecting causes parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getCauses(), causes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentDetails's causes does not contain the given DeploymentCause elements.
   *
   * @param causes the given elements that should not be in actual DeploymentDetails's causes.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentDetails's causes contains any given DeploymentCause elements.
   */
  public S doesNotHaveCauses(DeploymentCause... causes) {
    // check that actual DeploymentDetails we want to make assertions on is not null.
    isNotNull();

    // check that given DeploymentCause varargs is not null.
    if (causes == null) failWithMessage("Expecting causes parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getCauses(), causes);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentDetails has no causes.
   * @return this assertion object.
   * @throws AssertionError if the actual DeploymentDetails's causes is not empty.
   */
  public S hasNoCauses() {
    // check that actual DeploymentDetails we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have causes but had :\n  <%s>";
    
    // check
    if (actual.getCauses().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getCauses());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual DeploymentDetails's message is equal to the given one.
   * @param message the given message to compare the actual DeploymentDetails's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentDetails's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual DeploymentDetails we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
