package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ScaleSpecFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScaleSpecFluentImplAssert<S extends AbstractScaleSpecFluentImplAssert<S, A>, A extends ScaleSpecFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScaleSpecFluentImplAssert}</code> to make assertions on actual ScaleSpecFluentImpl.
   * @param actual the ScaleSpecFluentImpl we want to make assertions on.
   */
  protected AbstractScaleSpecFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ScaleSpecFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ScaleSpecFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ScaleSpecFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ScaleSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ScaleSpecFluentImpl's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual ScaleSpecFluentImpl's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ScaleSpecFluentImpl's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual ScaleSpecFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
