package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link JobStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractJobStatusFluentAssert<S extends AbstractJobStatusFluentAssert<S, A>, A extends JobStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractJobStatusFluentAssert}</code> to make assertions on actual JobStatusFluent.
   * @param actual the JobStatusFluent we want to make assertions on.
   */
  protected AbstractJobStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual JobStatusFluent's active is equal to the given one.
   * @param active the given active to compare the actual JobStatusFluent's active to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatusFluent's active is not equal to the given one.
   */
  public S hasActive(Integer active) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting active of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualActive = actual.getActive();
    if (!Objects.areEqual(actualActive, active)) {
      failWithMessage(assertjErrorMessage, actual, active, actualActive);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual JobStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobStatusFluent's completionTime is equal to the given one.
   * @param completionTime the given completionTime to compare the actual JobStatusFluent's completionTime to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatusFluent's completionTime is not equal to the given one.
   */
  public S hasCompletionTime(String completionTime) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting completionTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCompletionTime = actual.getCompletionTime();
    if (!Objects.areEqual(actualCompletionTime, completionTime)) {
      failWithMessage(assertjErrorMessage, actual, completionTime, actualCompletionTime);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobStatusFluent's conditions contains the given JobCondition elements.
   * @param conditions the given elements that should be contained in actual JobStatusFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual JobStatusFluent's conditions does not contain all given JobCondition elements.
   */
  public S hasConditions(JobCondition... conditions) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given JobCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobStatusFluent's conditions contains <b>only<b> the given JobCondition elements and nothing else in whatever order.
   * @param conditions the given elements that should be contained in actual JobStatusFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual JobStatusFluent's conditions does not contain all given JobCondition elements.
   */
  public S hasOnlyConditions(JobCondition... conditions) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given JobCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobStatusFluent's conditions does not contain the given JobCondition elements.
   *
   * @param conditions the given elements that should not be in actual JobStatusFluent's conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual JobStatusFluent's conditions contains any given JobCondition elements.
   */
  public S doesNotHaveConditions(JobCondition... conditions) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // check that given JobCondition varargs is not null.
    if (conditions == null) failWithMessage("Expecting conditions parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getConditions(), conditions);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobStatusFluent has no conditions.
   * @return this assertion object.
   * @throws AssertionError if the actual JobStatusFluent's conditions is not empty.
   */
  public S hasNoConditions() {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have conditions but had :\n  <%s>";
    
    // check
    if (actual.getConditions().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getConditions());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual JobStatusFluent's failed is equal to the given one.
   * @param failed the given failed to compare the actual JobStatusFluent's failed to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatusFluent's failed is not equal to the given one.
   */
  public S hasFailed(Integer failed) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting failed of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualFailed = actual.getFailed();
    if (!Objects.areEqual(actualFailed, failed)) {
      failWithMessage(assertjErrorMessage, actual, failed, actualFailed);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobStatusFluent's startTime is equal to the given one.
   * @param startTime the given startTime to compare the actual JobStatusFluent's startTime to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatusFluent's startTime is not equal to the given one.
   */
  public S hasStartTime(String startTime) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting startTime of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualStartTime = actual.getStartTime();
    if (!Objects.areEqual(actualStartTime, startTime)) {
      failWithMessage(assertjErrorMessage, actual, startTime, actualStartTime);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual JobStatusFluent's succeeded is equal to the given one.
   * @param succeeded the given succeeded to compare the actual JobStatusFluent's succeeded to.
   * @return this assertion object.
   * @throws AssertionError - if the actual JobStatusFluent's succeeded is not equal to the given one.
   */
  public S hasSucceeded(Integer succeeded) {
    // check that actual JobStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting succeeded of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualSucceeded = actual.getSucceeded();
    if (!Objects.areEqual(actualSucceeded, succeeded)) {
      failWithMessage(assertjErrorMessage, actual, succeeded, actualSucceeded);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
