package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IngressRuleFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressRuleFluentImplAssert<S extends AbstractIngressRuleFluentImplAssert<S, A>, A extends IngressRuleFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressRuleFluentImplAssert}</code> to make assertions on actual IngressRuleFluentImpl.
   * @param actual the IngressRuleFluentImpl we want to make assertions on.
   */
  protected AbstractIngressRuleFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IngressRuleFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IngressRuleFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressRuleFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IngressRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressRuleFluentImpl's host is equal to the given one.
   * @param host the given host to compare the actual IngressRuleFluentImpl's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressRuleFluentImpl's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual IngressRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressRuleFluentImpl's http is equal to the given one.
   * @param http the given http to compare the actual IngressRuleFluentImpl's http to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressRuleFluentImpl's http is not equal to the given one.
   */
  public S hasHttp(HTTPIngressRuleValue http) {
    // check that actual IngressRuleFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting http of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HTTPIngressRuleValue actualHttp = actual.getHttp();
    if (!Objects.areEqual(actualHttp, http)) {
      failWithMessage(assertjErrorMessage, actual, http, actualHttp);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
