/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PersistentVolumeSpecBuilder
extends PersistentVolumeSpecFluent<PersistentVolumeSpecBuilder>
implements VisitableBuilder<PersistentVolumeSpec, PersistentVolumeSpecBuilder> {
    PersistentVolumeSpecFluent<?> fluent;

    public PersistentVolumeSpecBuilder() {
        this(new PersistentVolumeSpec());
    }

    public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent) {
        this(fluent, new PersistentVolumeSpec());
    }

    public PersistentVolumeSpecBuilder(PersistentVolumeSpecFluent<?> fluent, PersistentVolumeSpec instance) {
        this.fluent = fluent;
        fluent.withAccessModes(instance.getAccessModes());
        fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        fluent.withCapacity(instance.getCapacity());
        fluent.withClaimRef(instance.getClaimRef());
        fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
        fluent.withGlusterfs(instance.getGlusterfs());
        fluent.withHostPath(instance.getHostPath());
        fluent.withNfs(instance.getNfs());
        fluent.withRbd(instance.getRbd());
    }

    public PersistentVolumeSpecBuilder(PersistentVolumeSpec instance) {
        this.fluent = this;
        this.withAccessModes(instance.getAccessModes());
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withCapacity(instance.getCapacity());
        this.withClaimRef(instance.getClaimRef());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withNfs(instance.getNfs());
        this.withRbd(instance.getRbd());
    }

    public EditablePersistentVolumeSpec build() {
        EditablePersistentVolumeSpec buildable = new EditablePersistentVolumeSpec(this.fluent.getAccessModes(), this.fluent.getAwsElasticBlockStore(), this.fluent.getCapacity(), this.fluent.getClaimRef(), this.fluent.getGcePersistentDisk(), this.fluent.getGlusterfs(), this.fluent.getHostPath(), this.fluent.getNfs(), this.fluent.getRbd());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

