package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ServiceSpecFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractServiceSpecFluentAssert<S extends AbstractServiceSpecFluentAssert<S, A>, A extends ServiceSpecFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractServiceSpecFluentAssert}</code> to make assertions on actual ServiceSpecFluent.
   * @param actual the ServiceSpecFluent we want to make assertions on.
   */
  protected AbstractServiceSpecFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ServiceSpecFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ServiceSpecFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSpecFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSpecFluent's deprecatedPublicIPs contains the given String elements.
   * @param deprecatedPublicIPs the given elements that should be contained in actual ServiceSpecFluent's deprecatedPublicIPs.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceSpecFluent's deprecatedPublicIPs does not contain all given String elements.
   */
  public S hasDeprecatedPublicIPs(String... deprecatedPublicIPs) {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (deprecatedPublicIPs == null) throw new AssertionError("Expecting deprecatedPublicIPs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getDeprecatedPublicIPs(), deprecatedPublicIPs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSpecFluent has no deprecatedPublicIPs.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceSpecFluent's deprecatedPublicIPs is not empty.
   */
  public S hasNoDeprecatedPublicIPs() {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have deprecatedPublicIPs but had :\n  <%s>";
    
    // check
    if (actual.getDeprecatedPublicIPs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getDeprecatedPublicIPs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ServiceSpecFluent's portalIP is equal to the given one.
   * @param portalIP the given portalIP to compare the actual ServiceSpecFluent's portalIP to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSpecFluent's portalIP is not equal to the given one.
   */
  public S hasPortalIP(String portalIP) {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected portalIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPortalIP = actual.getPortalIP();
    if (!Objects.areEqual(actualPortalIP, portalIP)) {
      failWithMessage(assertjErrorMessage, actual, portalIP, actualPortalIP);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSpecFluent's ports contains the given ServicePort elements.
   * @param ports the given elements that should be contained in actual ServiceSpecFluent's ports.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceSpecFluent's ports does not contain all given ServicePort elements.
   */
  public S hasPorts(ServicePort... ports) {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // check that given ServicePort varargs is not null.
    if (ports == null) throw new AssertionError("Expecting ports parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPorts(), ports);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSpecFluent has no ports.
   * @return this assertion object.
   * @throws AssertionError if the actual ServiceSpecFluent's ports is not empty.
   */
  public S hasNoPorts() {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have ports but had :\n  <%s>";
    
    // check
    if (actual.getPorts().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPorts());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual ServiceSpecFluent's selector is equal to the given one.
   * @param selector the given selector to compare the actual ServiceSpecFluent's selector to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSpecFluent's selector is not equal to the given one.
   */
  public S hasSelector(java.util.Map selector) {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualSelector = actual.getSelector();
    if (!Objects.areEqual(actualSelector, selector)) {
      failWithMessage(assertjErrorMessage, actual, selector, actualSelector);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSpecFluent's sessionAffinity is equal to the given one.
   * @param sessionAffinity the given sessionAffinity to compare the actual ServiceSpecFluent's sessionAffinity to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSpecFluent's sessionAffinity is not equal to the given one.
   */
  public S hasSessionAffinity(String sessionAffinity) {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected sessionAffinity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSessionAffinity = actual.getSessionAffinity();
    if (!Objects.areEqual(actualSessionAffinity, sessionAffinity)) {
      failWithMessage(assertjErrorMessage, actual, sessionAffinity, actualSessionAffinity);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ServiceSpecFluent's type is equal to the given one.
   * @param type the given type to compare the actual ServiceSpecFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ServiceSpecFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual ServiceSpecFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
