package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link HTTPGetActionFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHTTPGetActionFluentAssert<S extends AbstractHTTPGetActionFluentAssert<S, A>, A extends HTTPGetActionFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHTTPGetActionFluentAssert}</code> to make assertions on actual HTTPGetActionFluent.
   * @param actual the HTTPGetActionFluent we want to make assertions on.
   */
  protected AbstractHTTPGetActionFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual HTTPGetActionFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual HTTPGetActionFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetActionFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual HTTPGetActionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetActionFluent's host is equal to the given one.
   * @param host the given host to compare the actual HTTPGetActionFluent's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetActionFluent's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual HTTPGetActionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetActionFluent's path is equal to the given one.
   * @param path the given path to compare the actual HTTPGetActionFluent's path to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetActionFluent's path is not equal to the given one.
   */
  public S hasPath(String path) {
    // check that actual HTTPGetActionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPath = actual.getPath();
    if (!Objects.areEqual(actualPath, path)) {
      failWithMessage(assertjErrorMessage, actual, path, actualPath);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HTTPGetActionFluent's port is equal to the given one.
   * @param port the given port to compare the actual HTTPGetActionFluent's port to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HTTPGetActionFluent's port is not equal to the given one.
   */
  public S hasPort(IntOrString port) {
    // check that actual HTTPGetActionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    IntOrString actualPort = actual.getPort();
    if (!Objects.areEqual(actualPort, port)) {
      failWithMessage(assertjErrorMessage, actual, port, actualPort);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
