package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProjectStatusFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractProjectStatusFluentImplAssert<S extends AbstractProjectStatusFluentImplAssert<S, A>, A extends ProjectStatusFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProjectStatusFluentImplAssert}</code> to make assertions on actual ProjectStatusFluentImpl.
   * @param actual the ProjectStatusFluentImpl we want to make assertions on.
   */
  protected AbstractProjectStatusFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProjectStatusFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ProjectStatusFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectStatusFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ProjectStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectStatusFluentImpl's phase is equal to the given one.
   * @param phase the given phase to compare the actual ProjectStatusFluentImpl's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectStatusFluentImpl's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual ProjectStatusFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
