package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ProjectStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractProjectStatusAssert<S extends AbstractProjectStatusAssert<S, A>, A extends ProjectStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractProjectStatusAssert}</code> to make assertions on actual ProjectStatus.
   * @param actual the ProjectStatus we want to make assertions on.
   */
  protected AbstractProjectStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ProjectStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ProjectStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ProjectStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ProjectStatus's phase is equal to the given one.
   * @param phase the given phase to compare the actual ProjectStatus's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ProjectStatus's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual ProjectStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
