package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GitBuildSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGitBuildSourceAssert<S extends AbstractGitBuildSourceAssert<S, A>, A extends GitBuildSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGitBuildSourceAssert}</code> to make assertions on actual GitBuildSource.
   * @param actual the GitBuildSource we want to make assertions on.
   */
  protected AbstractGitBuildSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GitBuildSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GitBuildSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitBuildSource's httpProxy is equal to the given one.
   * @param httpProxy the given httpProxy to compare the actual GitBuildSource's httpProxy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSource's httpProxy is not equal to the given one.
   */
  public S hasHttpProxy(String httpProxy) {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting httpProxy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHttpProxy = actual.getHttpProxy();
    if (!Objects.areEqual(actualHttpProxy, httpProxy)) {
      failWithMessage(assertjErrorMessage, actual, httpProxy, actualHttpProxy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitBuildSource's httpsProxy is equal to the given one.
   * @param httpsProxy the given httpsProxy to compare the actual GitBuildSource's httpsProxy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSource's httpsProxy is not equal to the given one.
   */
  public S hasHttpsProxy(String httpsProxy) {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting httpsProxy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHttpsProxy = actual.getHttpsProxy();
    if (!Objects.areEqual(actualHttpsProxy, httpsProxy)) {
      failWithMessage(assertjErrorMessage, actual, httpsProxy, actualHttpsProxy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitBuildSource's ref is equal to the given one.
   * @param ref the given ref to compare the actual GitBuildSource's ref to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSource's ref is not equal to the given one.
   */
  public S hasRef(String ref) {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting ref of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRef = actual.getRef();
    if (!Objects.areEqual(actualRef, ref)) {
      failWithMessage(assertjErrorMessage, actual, ref, actualRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitBuildSource's uri is equal to the given one.
   * @param uri the given uri to compare the actual GitBuildSource's uri to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSource's uri is not equal to the given one.
   */
  public S hasUri(String uri) {
    // check that actual GitBuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting uri of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUri = actual.getUri();
    if (!Objects.areEqual(actualUri, uri)) {
      failWithMessage(assertjErrorMessage, actual, uri, actualUri);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
