package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link DeploymentStrategyFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentStrategyFluentAssert<S extends AbstractDeploymentStrategyFluentAssert<S, A>, A extends DeploymentStrategyFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentStrategyFluentAssert}</code> to make assertions on actual DeploymentStrategyFluent.
   * @param actual the DeploymentStrategyFluent we want to make assertions on.
   */
  protected AbstractDeploymentStrategyFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual DeploymentStrategyFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual DeploymentStrategyFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategyFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual DeploymentStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStrategyFluent's customParams is equal to the given one.
   * @param customParams the given customParams to compare the actual DeploymentStrategyFluent's customParams to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategyFluent's customParams is not equal to the given one.
   */
  public S hasCustomParams(CustomDeploymentStrategyParams customParams) {
    // check that actual DeploymentStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting customParams of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    CustomDeploymentStrategyParams actualCustomParams = actual.getCustomParams();
    if (!Objects.areEqual(actualCustomParams, customParams)) {
      failWithMessage(assertjErrorMessage, actual, customParams, actualCustomParams);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStrategyFluent's recreateParams is equal to the given one.
   * @param recreateParams the given recreateParams to compare the actual DeploymentStrategyFluent's recreateParams to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategyFluent's recreateParams is not equal to the given one.
   */
  public S hasRecreateParams(RecreateDeploymentStrategyParams recreateParams) {
    // check that actual DeploymentStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting recreateParams of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RecreateDeploymentStrategyParams actualRecreateParams = actual.getRecreateParams();
    if (!Objects.areEqual(actualRecreateParams, recreateParams)) {
      failWithMessage(assertjErrorMessage, actual, recreateParams, actualRecreateParams);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStrategyFluent's resources is equal to the given one.
   * @param resources the given resources to compare the actual DeploymentStrategyFluent's resources to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategyFluent's resources is not equal to the given one.
   */
  public S hasResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
    // check that actual DeploymentStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting resources of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ResourceRequirements actualResources = actual.getResources();
    if (!Objects.areEqual(actualResources, resources)) {
      failWithMessage(assertjErrorMessage, actual, resources, actualResources);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStrategyFluent's rollingParams is equal to the given one.
   * @param rollingParams the given rollingParams to compare the actual DeploymentStrategyFluent's rollingParams to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategyFluent's rollingParams is not equal to the given one.
   */
  public S hasRollingParams(RollingDeploymentStrategyParams rollingParams) {
    // check that actual DeploymentStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting rollingParams of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    RollingDeploymentStrategyParams actualRollingParams = actual.getRollingParams();
    if (!Objects.areEqual(actualRollingParams, rollingParams)) {
      failWithMessage(assertjErrorMessage, actual, rollingParams, actualRollingParams);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentStrategyFluent's type is equal to the given one.
   * @param type the given type to compare the actual DeploymentStrategyFluent's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentStrategyFluent's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual DeploymentStrategyFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
