package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link Dec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDecAssert<S extends AbstractDecAssert<S, A>, A extends Dec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDecAssert}</code> to make assertions on actual Dec.
   * @param actual the Dec we want to make assertions on.
   */
  protected AbstractDecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual Dec's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual Dec's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual Dec's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual Dec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
