package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CustomBuildStrategyFluentImpl} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomBuildStrategyFluentImplAssert<S extends AbstractCustomBuildStrategyFluentImplAssert<S, A>, A extends CustomBuildStrategyFluentImpl> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomBuildStrategyFluentImplAssert}</code> to make assertions on actual CustomBuildStrategyFluentImpl.
   * @param actual the CustomBuildStrategyFluentImpl we want to make assertions on.
   */
  protected AbstractCustomBuildStrategyFluentImplAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CustomBuildStrategyFluentImpl's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategyFluentImpl's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's env contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param env the given elements that should be contained in actual CustomBuildStrategyFluentImpl's env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluentImpl's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's env contains <b>only<b> the given io.fabric8.kubernetes.api.model.EnvVar elements and nothing else in whatever order.
   * @param env the given elements that should be contained in actual CustomBuildStrategyFluentImpl's env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluentImpl's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasOnlyEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's env does not contain the given io.fabric8.kubernetes.api.model.EnvVar elements.
   *
   * @param env the given elements that should not be in actual CustomBuildStrategyFluentImpl's env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluentImpl's env contains any given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S doesNotHaveEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) failWithMessage("Expecting env parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluentImpl's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's from is equal to the given one.
   * @param from the given from to compare the actual CustomBuildStrategyFluentImpl's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategyFluentImpl's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's pullSecret is equal to the given one.
   * @param pullSecret the given pullSecret to compare the actual CustomBuildStrategyFluentImpl's pullSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategyFluentImpl's pullSecret is not equal to the given one.
   */
  public S hasPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting pullSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualPullSecret = actual.getPullSecret();
    if (!Objects.areEqual(actualPullSecret, pullSecret)) {
      failWithMessage(assertjErrorMessage, actual, pullSecret, actualPullSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's secrets contains the given SecretSpec elements.
   * @param secrets the given elements that should be contained in actual CustomBuildStrategyFluentImpl's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluentImpl's secrets does not contain all given SecretSpec elements.
   */
  public S hasSecrets(SecretSpec... secrets) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given SecretSpec varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's secrets contains <b>only<b> the given SecretSpec elements and nothing else in whatever order.
   * @param secrets the given elements that should be contained in actual CustomBuildStrategyFluentImpl's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluentImpl's secrets does not contain all given SecretSpec elements.
   */
  public S hasOnlySecrets(SecretSpec... secrets) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given SecretSpec varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl's secrets does not contain the given SecretSpec elements.
   *
   * @param secrets the given elements that should not be in actual CustomBuildStrategyFluentImpl's secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluentImpl's secrets contains any given SecretSpec elements.
   */
  public S doesNotHaveSecrets(SecretSpec... secrets) {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // check that given SecretSpec varargs is not null.
    if (secrets == null) failWithMessage("Expecting secrets parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getSecrets(), secrets);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategyFluentImpl has no secrets.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategyFluentImpl's secrets is not empty.
   */
  public S hasNoSecrets() {
    // check that actual CustomBuildStrategyFluentImpl we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have secrets but had :\n  <%s>";
    
    // check
    if (actual.getSecrets().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getSecrets());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
