package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildSourceAssert<S extends AbstractBuildSourceAssert<S, A>, A extends BuildSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildSourceAssert}</code> to make assertions on actual BuildSource.
   * @param actual the BuildSource we want to make assertions on.
   */
  protected AbstractBuildSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSource's binary is equal to the given one.
   * @param binary the given binary to compare the actual BuildSource's binary to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSource's binary is not equal to the given one.
   */
  public S hasBinary(BinaryBuildSource binary) {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting binary of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    BinaryBuildSource actualBinary = actual.getBinary();
    if (!Objects.areEqual(actualBinary, binary)) {
      failWithMessage(assertjErrorMessage, actual, binary, actualBinary);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSource's contextDir is equal to the given one.
   * @param contextDir the given contextDir to compare the actual BuildSource's contextDir to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSource's contextDir is not equal to the given one.
   */
  public S hasContextDir(String contextDir) {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting contextDir of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualContextDir = actual.getContextDir();
    if (!Objects.areEqual(actualContextDir, contextDir)) {
      failWithMessage(assertjErrorMessage, actual, contextDir, actualContextDir);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSource's dockerfile is equal to the given one.
   * @param dockerfile the given dockerfile to compare the actual BuildSource's dockerfile to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSource's dockerfile is not equal to the given one.
   */
  public S hasDockerfile(String dockerfile) {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting dockerfile of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualDockerfile = actual.getDockerfile();
    if (!Objects.areEqual(actualDockerfile, dockerfile)) {
      failWithMessage(assertjErrorMessage, actual, dockerfile, actualDockerfile);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSource's git is equal to the given one.
   * @param git the given git to compare the actual BuildSource's git to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSource's git is not equal to the given one.
   */
  public S hasGit(GitBuildSource git) {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting git of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    GitBuildSource actualGit = actual.getGit();
    if (!Objects.areEqual(actualGit, git)) {
      failWithMessage(assertjErrorMessage, actual, git, actualGit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSource's sourceSecret is equal to the given one.
   * @param sourceSecret the given sourceSecret to compare the actual BuildSource's sourceSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSource's sourceSecret is not equal to the given one.
   */
  public S hasSourceSecret(io.fabric8.kubernetes.api.model.LocalObjectReference sourceSecret) {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting sourceSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualSourceSecret = actual.getSourceSecret();
    if (!Objects.areEqual(actualSourceSecret, sourceSecret)) {
      failWithMessage(assertjErrorMessage, actual, sourceSecret, actualSourceSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildSource's type is equal to the given one.
   * @param type the given type to compare the actual BuildSource's type to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildSource's type is not equal to the given one.
   */
  public S hasType(String type) {
    // check that actual BuildSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualType = actual.getType();
    if (!Objects.areEqual(actualType, type)) {
      failWithMessage(assertjErrorMessage, actual, type, actualType);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
