package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildOutput} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildOutputAssert<S extends AbstractBuildOutputAssert<S, A>, A extends BuildOutput> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildOutputAssert}</code> to make assertions on actual BuildOutput.
   * @param actual the BuildOutput we want to make assertions on.
   */
  protected AbstractBuildOutputAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildOutput's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildOutput's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildOutput's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildOutput we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildOutput's pushSecret is equal to the given one.
   * @param pushSecret the given pushSecret to compare the actual BuildOutput's pushSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildOutput's pushSecret is not equal to the given one.
   */
  public S hasPushSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pushSecret) {
    // check that actual BuildOutput we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting pushSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualPushSecret = actual.getPushSecret();
    if (!Objects.areEqual(actualPushSecret, pushSecret)) {
      failWithMessage(assertjErrorMessage, actual, pushSecret, actualPushSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildOutput's to is equal to the given one.
   * @param to the given to to compare the actual BuildOutput's to to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildOutput's to is not equal to the given one.
   */
  public S hasTo(io.fabric8.kubernetes.api.model.ObjectReference to) {
    // check that actual BuildOutput we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting to of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualTo = actual.getTo();
    if (!Objects.areEqual(actualTo, to)) {
      failWithMessage(assertjErrorMessage, actual, to, actualTo);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
