package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link BuildConfigStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildConfigStatusFluentAssert<S extends AbstractBuildConfigStatusFluentAssert<S, A>, A extends BuildConfigStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildConfigStatusFluentAssert}</code> to make assertions on actual BuildConfigStatusFluent.
   * @param actual the BuildConfigStatusFluent we want to make assertions on.
   */
  protected AbstractBuildConfigStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual BuildConfigStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual BuildConfigStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual BuildConfigStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual BuildConfigStatusFluent's lastVersion is equal to the given one.
   * @param lastVersion the given lastVersion to compare the actual BuildConfigStatusFluent's lastVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual BuildConfigStatusFluent's lastVersion is not equal to the given one.
   */
  public S hasLastVersion(Integer lastVersion) {
    // check that actual BuildConfigStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting lastVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualLastVersion = actual.getLastVersion();
    if (!Objects.areEqual(actualLastVersion, lastVersion)) {
      failWithMessage(assertjErrorMessage, actual, lastVersion, actualLastVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
