package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RollingUpdateDeploymentFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRollingUpdateDeploymentFluentAssert<S extends AbstractRollingUpdateDeploymentFluentAssert<S, A>, A extends RollingUpdateDeploymentFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRollingUpdateDeploymentFluentAssert}</code> to make assertions on actual RollingUpdateDeploymentFluent.
   * @param actual the RollingUpdateDeploymentFluent we want to make assertions on.
   */
  protected AbstractRollingUpdateDeploymentFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RollingUpdateDeploymentFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RollingUpdateDeploymentFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingUpdateDeploymentFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RollingUpdateDeploymentFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RollingUpdateDeploymentFluent's maxSurge is equal to the given one.
   * @param maxSurge the given maxSurge to compare the actual RollingUpdateDeploymentFluent's maxSurge to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingUpdateDeploymentFluent's maxSurge is not equal to the given one.
   */
  public S hasMaxSurge(io.fabric8.kubernetes.api.model.IntOrString maxSurge) {
    // check that actual RollingUpdateDeploymentFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting maxSurge of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.IntOrString actualMaxSurge = actual.getMaxSurge();
    if (!Objects.areEqual(actualMaxSurge, maxSurge)) {
      failWithMessage(assertjErrorMessage, actual, maxSurge, actualMaxSurge);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RollingUpdateDeploymentFluent's maxUnavailable is equal to the given one.
   * @param maxUnavailable the given maxUnavailable to compare the actual RollingUpdateDeploymentFluent's maxUnavailable to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingUpdateDeploymentFluent's maxUnavailable is not equal to the given one.
   */
  public S hasMaxUnavailable(io.fabric8.kubernetes.api.model.IntOrString maxUnavailable) {
    // check that actual RollingUpdateDeploymentFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting maxUnavailable of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.IntOrString actualMaxUnavailable = actual.getMaxUnavailable();
    if (!Objects.areEqual(actualMaxUnavailable, maxUnavailable)) {
      failWithMessage(assertjErrorMessage, actual, maxUnavailable, actualMaxUnavailable);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RollingUpdateDeploymentFluent's minReadySeconds is equal to the given one.
   * @param minReadySeconds the given minReadySeconds to compare the actual RollingUpdateDeploymentFluent's minReadySeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RollingUpdateDeploymentFluent's minReadySeconds is not equal to the given one.
   */
  public S hasMinReadySeconds(Integer minReadySeconds) {
    // check that actual RollingUpdateDeploymentFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting minReadySeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMinReadySeconds = actual.getMinReadySeconds();
    if (!Objects.areEqual(actualMinReadySeconds, minReadySeconds)) {
      failWithMessage(assertjErrorMessage, actual, minReadySeconds, actualMinReadySeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
