package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link PodSelectorRequirement} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPodSelectorRequirementAssert<S extends AbstractPodSelectorRequirementAssert<S, A>, A extends PodSelectorRequirement> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPodSelectorRequirementAssert}</code> to make assertions on actual PodSelectorRequirement.
   * @param actual the PodSelectorRequirement we want to make assertions on.
   */
  protected AbstractPodSelectorRequirementAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual PodSelectorRequirement's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual PodSelectorRequirement's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSelectorRequirement's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual PodSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelectorRequirement's key is equal to the given one.
   * @param key the given key to compare the actual PodSelectorRequirement's key to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSelectorRequirement's key is not equal to the given one.
   */
  public S hasKey(String key) {
    // check that actual PodSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting key of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKey = actual.getKey();
    if (!Objects.areEqual(actualKey, key)) {
      failWithMessage(assertjErrorMessage, actual, key, actualKey);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelectorRequirement's operator is equal to the given one.
   * @param operator the given operator to compare the actual PodSelectorRequirement's operator to.
   * @return this assertion object.
   * @throws AssertionError - if the actual PodSelectorRequirement's operator is not equal to the given one.
   */
  public S hasOperator(String operator) {
    // check that actual PodSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting operator of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualOperator = actual.getOperator();
    if (!Objects.areEqual(actualOperator, operator)) {
      failWithMessage(assertjErrorMessage, actual, operator, actualOperator);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelectorRequirement's values contains the given String elements.
   * @param values the given elements that should be contained in actual PodSelectorRequirement's values.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSelectorRequirement's values does not contain all given String elements.
   */
  public S hasValues(String... values) {
    // check that actual PodSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (values == null) failWithMessage("Expecting values parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getValues(), values);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelectorRequirement's values contains <b>only<b> the given String elements and nothing else in whatever order.
   * @param values the given elements that should be contained in actual PodSelectorRequirement's values.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSelectorRequirement's values does not contain all given String elements.
   */
  public S hasOnlyValues(String... values) {
    // check that actual PodSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (values == null) failWithMessage("Expecting values parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContainsOnly(info, actual.getValues(), values);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelectorRequirement's values does not contain the given String elements.
   *
   * @param values the given elements that should not be in actual PodSelectorRequirement's values.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSelectorRequirement's values contains any given String elements.
   */
  public S doesNotHaveValues(String... values) {
    // check that actual PodSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (values == null) failWithMessage("Expecting values parameter not to be null.");
    
    // check with standard error message (use overridingErrorMessage before contains to set your own message).
    Iterables.instance().assertDoesNotContain(info, actual.getValues(), values);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual PodSelectorRequirement has no values.
   * @return this assertion object.
   * @throws AssertionError if the actual PodSelectorRequirement's values is not empty.
   */
  public S hasNoValues() {
    // check that actual PodSelectorRequirement we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have values but had :\n  <%s>";
    
    // check
    if (actual.getValues().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getValues());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
