package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link IngressStatusFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressStatusFluentAssert<S extends AbstractIngressStatusFluentAssert<S, A>, A extends IngressStatusFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressStatusFluentAssert}</code> to make assertions on actual IngressStatusFluent.
   * @param actual the IngressStatusFluent we want to make assertions on.
   */
  protected AbstractIngressStatusFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual IngressStatusFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual IngressStatusFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressStatusFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual IngressStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual IngressStatusFluent's loadBalancer is equal to the given one.
   * @param loadBalancer the given loadBalancer to compare the actual IngressStatusFluent's loadBalancer to.
   * @return this assertion object.
   * @throws AssertionError - if the actual IngressStatusFluent's loadBalancer is not equal to the given one.
   */
  public S hasLoadBalancer(io.fabric8.kubernetes.api.model.LoadBalancerStatus loadBalancer) {
    // check that actual IngressStatusFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting loadBalancer of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LoadBalancerStatus actualLoadBalancer = actual.getLoadBalancer();
    if (!Objects.areEqual(actualLoadBalancer, loadBalancer)) {
      failWithMessage(assertjErrorMessage, actual, loadBalancer, actualLoadBalancer);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
